DELIMITER $$
DROP PROCEDURE IF EXISTS V20220920162136__Create_FunctionaryProgressReportTable $$
CREATE PROCEDURE V20220920162136__Create_FunctionaryProgressReportTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='functionary_progress_report')) THEN 
CREATE TABLE `functionary_progress_report`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint NOT NULL,
`progressReportPeriodStartDate` date NOT NULL,
`progressReportPeriodEndDate` date NOT NULL,
`responsibleFunctionaryEmployeeID` BIGINT(20) NOT NULL,
`name` VARCHAR(255) NOT NULL,
`lastName` VARCHAR(255) NULL DEFAULT NULL,
`functionaryType` bigint(20) NOT NULL,
`auditDate` date DEFAULT NULL,
`auditId` bigint NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_functionaryProgressReport_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_functionaryProgressReport_SU_functionaryType` FOREIGN KEY (`functionaryType`) REFERENCES `functionary_type` (`id`),
CONSTRAINT `FK_functionaryProgressReport_SU_responsibleFunctionaryEmployeeID` FOREIGN KEY (`responsibleFunctionaryEmployeeID`) REFERENCES `users` (`id`),
CONSTRAINT `FK_functionaryProgressReport_SU_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_functionaryProgressReport_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
 ) ;
END IF; 

END $$
CALL V20220920162136__Create_FunctionaryProgressReportTable () $$ 
DROP PROCEDURE IF EXISTS V20220920162136__Create_FunctionaryProgressReportTable $$ 
DELIMITER ;