DELIMITER $$
DROP PROCEDURE IF EXISTS V20221013190923__Update_ApplicantAddAndInfoDydtDataLineItem $$
CREATE PROCEDURE V20221013190923__Update_ApplicantAddAndInfoDydtDataLineItem()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICANT_ADDRESS_INFO')) THEN 
SET @dydtDataLineItemId=(select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICANT_ADDRESS_INFO');
update dydt_data_line_item set resultColumnsDef="ap_country_name,ap_region_name,ap_parent_region_name,ap_city_name,ap_address_detail,ap_phone_country_code,ap_phone_area_code,ap_phone_no,ap_cell_country_code,ap_cell_no,ap_primary_email_id,ap_pincode",
sqlSelectQueryDef="SELECT  c.countryName AS ap_country_name , cr.countryRegionName AS ap_region_name ,pr.countryRegionName AS ap_parent_region_name,ct.cityName AS ap_city_name , addressText AS ap_address_detail,ad.phoneCountryCode AS ap_phone_country_code,ad.phoneAreaCode AS ap_phone_area_code,ad.phoneNo AS ap_phone_no ,ad.cellCountryCode AS ap_cell_country_code,ad.cellNo AS ap_cell_no ,ad.primaryEmailId AS ap_primary_email_idr, ad.pincode AS ap_pincode FROM applicant_address ad LEFT JOIN city ct ON ct.id =ad.cityId LEFT JOIN country c ON ad.countryId = c.id LEFT JOIN country_region cr ON ad.countryRegionId = cr.id LEFT JOIN country_region pr ON ad.parentRegionId = pr.id LEFT JOIN applicant_person ap ON ad.applicantPersonId = ap.id" 
where id=@dydtDataLineItemId;
END IF; 

IF EXISTS ((select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICATION_INFO' and whereClauseBindingDef='PRM_APPLICATION_ID')) THEN 
SET @dydtDataLineItemId=(select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICATION_INFO' and whereClauseBindingDef='PRM_APPLICATION_ID');
update dydt_data_line_item set resultColumnsDef="applicant_firstname,applicant_lastname,applicant_middlename,applicant_gender,applicant_printname,application_code,applicant_salutation,birth_date,app_photo_url,Hostel_Applicable,correspondance_language,current_activity,applicant_salutation_otr_lang,ap_nationalID",
sqlSelectQueryDef="SELECT ap.firstName AS applicant_firstname ,ap.lastName AS applicant_lastname ,ap.middleName AS applicant_middlename, 
       ap.gender AS applicant_gender,ap.printName  AS applicant_printname,a.code as application_code,
       s.salutationName as applicant_salutation,ap.birthDate as birth_date,ap.photoUrl as app_photo_url,
       ahr.whetherHostelApplicable as Hostel_Applicable,
       ml.itemValue as correspondance_language,ca.itemValue as current_activity,
       s.salutationNameInOtherLanguage AS applicant_salutation_otr_lang,
       ap.nationalID AS ap_nationalID
       FROM application a
       LEFT JOIN  applicant_person ap ON a.applicantPersonId = ap.id
       LEFT JOIN applicant_hostel_requirement ahr ON ahr.applicantPersonId = ap.id
       LEFT JOIN salutations s ON ap.salutationId = s.id
       LEFT JOIN current_activity ca on ca.id = ap.current_activity_id
       LEFT JOIN multi_language ml ON ml.id = ap.correspondence_language" 
where id=@dydtDataLineItemId;
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20221013190923__Update_ApplicantAddAndInfoDydtDataLineItem () $$
DROP PROCEDURE IF EXISTS V20221013190923__Update_ApplicantAddAndInfoDydtDataLineItem $$
DELIMITER ;
