DELIMITER $$
DROP PROCEDURE IF EXISTS V20221104123039__Update_TaskParticipantDLRecipient $$
CREATE PROCEDURE V20221104123039__Update_TaskParticipantDLRecipient()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='TASK_PARTICIPANT_DL')) THEN 
SET @taskEventAssign=(SELECT id FROM dtprovider WHERE `dataProviderName`='TASK_PARTICIPANT_DL');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
T5.ownerId AS USER_ID
FROM
   `users` T1
INNER JOIN
`staffs` T4 ON T4.`userId` = T1.`id`
LEFT JOIN
   `persons` T2 ON T2.`id` = T4.`personId`
LEFT JOIN
   `salutations` T3 ON T3.`id` = T2.`salutationId`
   LEFT JOIN
`event_meeting_minutes_task` T5 on T1.id=T5.ownerId
   LEFT JOIN
`event_meeting_minutes` T6 on T6.id=T5.minuteId
WHERE
   T5.minuteId IN (namedParams)
     AND T6.minuteTakerId != T5.ownerId" WHERE `dataProviderId`=@taskEventAssign;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`="Task Participant Recipient")) THEN 
SET @taskEventAssign=(SELECT id FROM dtprovider WHERE `dataProviderName`="Task Participant Recipient");

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    `users` T1 
    INNER JOIN
    `staffs` T4 ON T4.`userId` = T1.`id`
    LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
    LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
    multi_language ml on ml.id=T2.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@taskEventAssign;
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20221104123039__Update_TaskParticipantDLRecipient () $$
DROP PROCEDURE IF EXISTS V20221104123039__Update_TaskParticipantDLRecipient $$
DELIMITER ;