-- V2D-320371 Messaging for Hostel Check-in  Event

DELIMITER $$
DROP PROCEDURE IF EXISTS V202211161443__Insert_ForApplicationFeePaymentEvent $$
CREATE PROCEDURE V202211161443__Insert_ForApplicationFeePaymentEvent()
BEGIN

IF NOT EXISTS ((select * from system_msg_event where code='APPLICATION_FEE_PAYMENT_EVENT')) THEN	
	
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'APPLICATION_FEE_PAYMENT');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPLICATION_FEE_PAYMENT');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'APPLICATION_FEE_PAYMENT_EVENT', 'Application Fee Payment', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Application Fee Payment');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_FEE_PAYMENT_EVENT_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_FEE_PAYMENT_EVENT_RCPNT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FEE_PAYMENT_EVENT_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICATION_FEE_PAYMENT_EVENT_RCPNT');


-- The under sql code gives for the user distribution list ,this information can be fetched

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FEE_PAYMENT_EVENT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_FEE_PAYMENT_EVENT_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FEE_PAYMENT_EVENT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select id as USER_ID from receipt_header WHERE id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FEE_PAYMENT_EVENT_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T11.id AS ID,
    T8.firstName AS APP_FIRST_NAME,
    T8.lastName AS APP_LAST_NAME,
    T1.code AS APPLICATION_ID,
    T11.transactionDate AS SETTLEMENT_DATE,
    T11.receiptNo AS RECEIPT_NO,
    T2.billNo AS BILL_NO,
    T18.printName AS APPLICATION_OWNER,
    T18.firstName AS FIRST_NAME,
    T18.lastName AS LAST_NAME,
    T18.printName AS PRINT_NAME,
    T18.emailId AS EMAIL_ID,
    T18.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T18.mobileCountryCode as MOBILE_CODE,
    T18.mobileNumber as MOBILE_NO,
    T13.programName AS PROGRAM_NAME,
    T7.displayName AS ACADEMY_LOCATION_NAME,
    T15.batchName AS BATCH_NAME,
    T16.itemValue AS INTAKE_YEAR,
    T20.primaryeEmailId AS ACADEMIC_PRIMARY_EMAIL_ID
FROM
    application T1
        LEFT JOIN
    bill_header T2 ON T2.applicantId = T1.id
        LEFT JOIN
    bill_fee_plan_rule_stage T3 ON T3.billId = T2.id
        LEFT JOIN
    fee_stage_head_config T4 ON T4.id = T3.feeStageHeadConfigId
        LEFT JOIN
    fee_plan_rule_stage T5 ON T5.id = T4.feePlanRuleStageId
     LEFT JOIN
    fee_stage_master fsm ON fsm.id = T5.stageId
        LEFT JOIN
    users T6 ON T6.id = (CASE
                WHEN
                    T1.applicationOwner is null
                THEN
                    (select defaultUserId from  application_default_user  where academyLocationId=T1.issuedFromAcademyLocation)
                ELSE T1.applicationOwner
            END)
        LEFT JOIN
    academy_location T7 ON T7.id = T1.issuedFromAcademyLocation
        LEFT JOIN
    applicant_person T8 ON T8.id = T1.applicantPersonId
        LEFT JOIN
    fee_adjustment_details T9 ON T9.billHeaderId = T2.id
        LEFT JOIN
    fee_adjustment_master T10 ON T10.id = T9.adjustmentMasterId
        LEFT JOIN
    receipt_header T11 ON T11.id = T10.receiptHeaderId
        LEFT JOIN
    application_program T12 ON T12.applicationId = T1.id
        LEFT JOIN
    programs T13 ON T13.id = T12.programId
        LEFT JOIN
    prog_batch_seat_config T14 ON T14.id = T12.progBatchSeatConfigId
        LEFT JOIN
    batches T15 ON T15.id = T14.programBatchId
        LEFT JOIN
    intake_year T16 ON T16.id = T15.intakeYearId
        LEFT JOIN
    staffs T17 ON T17.userId = T6.id
        LEFT JOIN
    persons T18 ON T18.id = T17.personId 
        LEFT JOIN
    academy_location_addresses T19 ON T19.academyLocationId = T7.id
        LEFT JOIN
    address T20 ON T20.id = T19.addressId
        AND T20.addressTypeId = 10
WHERE
    T11.id IN (namedParams)
	AND fsm.stageName in ('Application form sale' ,'Application submission')
        AND T2.billStatus = 'SETTLED' 
GROUP BY T2.id  order by T2.lastUpdate desc",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "firstName",
            "resultKey": "APP_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "lastName",
            "resultKey": "APP_LAST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "code",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 2
        },        
        {
            "id": 4,
            "value": "transactionDate",
            "resultKey": "SETTLEMENT_DATE",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "receiptNo",
            "resultKey": "RECEIPT_NO",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "printName",
            "resultKey": "APPLICATION_OWNER",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "batchName",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INTAKE_YEAR",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMIC_PRIMARY_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 10
        }
    ]
}');




SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICATION_FEE_PAYMENT_EVENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPLICATION_FEE_PAYMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_FEE_PAYMENT_EVENT_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Application Fee payment Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Application Fee payment Template',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1','English',TRUE);


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Application Fee Payment Confirmation','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;APPLICATION_OWNER&quot;]&nbsp;</strong>,</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Successful Application fees Payment has been done by <strong>$recipientData[&quot;APP_FIRST_NAME&quot;]</strong> <strong>$recipientData[&quot;APP_LAST_NAME&quot;]</strong> <strong>$recipientData[&quot;APPLICATION_ID&quot;]</strong> </span></span></p>
<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Please refer to Bill No.-<strong>$recipientData[&quot;BILL_NO&quot;]</strong> & Receipt No.-<strong>$recipientData[&quot;RECEIPT_NO&quot;]</strong></span></span></p>

<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">You may proceed further with the application.</span></span></p>

<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,</br><strong>$recipientData[&quot;ACADEMY_LOCATION_NAME&quot;]</strong></span></span></p>

			</td>
		</tr>
		
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Application Fee Payment Confirmation','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;APPLICATION_OWNER&quot;]&nbsp;</strong>,</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Successful Application fees Payment has been done by <strong>$recipientData[&quot;APP_FIRST_NAME&quot;]</strong> <strong>$recipientData[&quot;APP_LAST_NAME&quot;]</strong> <strong>$recipientData[&quot;APPLICATION_ID&quot;]</strong> </span></span></p>
<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Please refer to Bill No.-<strong>$recipientData[&quot;BILL_NO&quot;]</strong> & Receipt No.-<strong>$recipientData[&quot;RECEIPT_NO&quot;]</strong></span></span></p>

<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">You may proceed further with the application.</span></span></p>

<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,</br><strong>$recipientData[&quot;ACADEMY_LOCATION_NAME&quot;]</strong></span></span></p>

			</td>
		</tr>
		
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["APPLICATION_OWNER"] ,

Successful Application fees Payment has been done by $recipientData["APP_FIRST_NAME"] $recipientData["APP_LAST_NAME"] $recipientData["APPLICATION_ID"]

Please refer to Bill No.-$recipientData["BILL_NO"] & Receipt No.-$recipientData["RECEIPT_NO"]

You may proceed further with the application.');




-- End Messaging for STUDENT_HOSTEL_CHECK_IN Event

END IF; 

END $$
CALL V202211161443__Insert_ForApplicationFeePaymentEvent() $$
DROP PROCEDURE IF EXISTS V202211161443__Insert_ForApplicationFeePaymentEvent $$
DELIMITER ;