DELIMITER $$
DROP PROCEDURE IF EXISTS V20221228130111__Create_LateFeeConfigSetUpTable $$
CREATE PROCEDURE V20221228130111__Create_LateFeeConfigSetUpTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='late_fee_configuration_setup')) THEN 
CREATE TABLE `late_fee_configuration_setup`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `termwiseCourseRegistrationId` BIGINT(20) NOT NULL,
  `feePlanType` BIGINT(20) NOT NULL,
  `feePlanId` BIGINT(20) NOT NULL,
  `feeStageMasterId` BIGINT(10) NOT NULL,
  `feePlanRuleId` BIGINT(10) NOT NULL,
  `amount` double(20,2) NULL,
  `whetherActive` bit(1) DEFAULT false,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `term_wise_course_registration_termwiseCourseRegistrationId_FK` FOREIGN KEY (`termwiseCourseRegistrationId`) REFERENCES `term_wise_course_registration`(`id`),
  CONSTRAINT `feePlanType_feePlanTypeId_FK` FOREIGN KEY (`feePlanType`) REFERENCES `fee_plan_type`(`id`),
  CONSTRAINT `fee_plan_feePlanId_late_fee_FK` FOREIGN KEY (`feePlanId`) REFERENCES `fee_plan`(`id`),
  CONSTRAINT `fee_stage_master_feeStageMasterId_late_fee_FK` FOREIGN KEY (`feeStageMasterId`) REFERENCES `fee_stage_master`(`id`),
  CONSTRAINT `fee_plan_rules_feePlanRuleId_late_fee_FK` FOREIGN KEY (`feePlanRuleId`) REFERENCES `fee_plan_rules`(`id`),
  CONSTRAINT `late_fee_configuration_setup_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`));
END IF; 

END $$
CALL V20221228130111__Create_LateFeeConfigSetUpTable () $$ 
DROP PROCEDURE IF EXISTS V20221228130111__Create_LateFeeConfigSetUpTable $$ 
DELIMITER ;