DELIMITER $$
DROP PROCEDURE IF EXISTS V20221229114050__Insert_KKUTemplate $$
CREATE PROCEDURE V20221229114050__Insert_KKUTemplate()
BEGIN
	
set @reportTypeTempId = (select max(id) from report_type where typeName='Receipt' );	

IF NOT EXISTS ((SELECT * FROM `report_template` where `reportTypeId`=@reportTypeTempId and `templateCode`='MANAGE_RECEIPT_CODE' and `templateName`='KKU Receipt')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES (@reportTypeTempId, 'MANAGE_RECEIPT_CODE', 'KKU Receipt', 'RECEIPT_CODE_UWC.png', 'CommonReport_LandScape.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'RECEIPT_CODE_KKU.jasper', 'AcademiaLogo.jpg');
END IF; 

set @rID = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_CODE');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_OFFICE_COPY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_OFFICE_COPY', 'Office copy', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_BANK_COPY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_BANK_COPY', 'Bank copy', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_STUDENT_COPY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_STUDENT_COPY', 'Student copy', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_BRANCH_BANK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_BRANCH_BANK', 'Branch', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_IFSC')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_IFSC', 'IFSC', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_PAY_IN_SLIP')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_PAY_IN_SLIP', 'PAY IN SLIP', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_PAY_TO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_PAY_TO', 'Pay to', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_A/C_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_A/C_NO', 'A/c No', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_BRANCH')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_BRANCH', 'Branch', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ADM_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ADM_NO', 'Adm No', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_STUDENT_NAME', 'Student Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_FATHER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_FATHER_NAME', 'Father Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_COURSE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_COURSE', 'Course', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_SESSION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_SESSION', 'Session', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_Particular')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_Particular', 'Particular', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_AMOUNT', 'Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TOTAL_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TOTAL_AMOUNT', 'Total Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TOTAL_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TOTAL_FEE', 'Total Fee', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_WORDS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_WORDS', 'In words', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_REMARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_REMARKS', 'Remarks', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_DATE_TIME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_DATE_TIME', 'Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_SIGNATURE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_SIGNATURE', 'Signature', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_CASHIER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_CASHIER', 'Cashier', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_VALID_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_VALID_DATE', 'Valid Till', '1', now());
END IF;

END $$
CALL V20221229114050__Insert_KKUTemplate() $$
DROP PROCEDURE IF EXISTS V20221229114050__Insert_KKUTemplate $$
DELIMITER ;