DELIMITER $$
DROP PROCEDURE IF EXISTS V20221230114459__Create_EmployeeAdditionalInformationMain $$
CREATE PROCEDURE V20221230114459__Create_EmployeeAdditionalInformationMain()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='employees_additional_information')) THEN 
CREATE TABLE `employees_additional_information` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`userId` BIGINT NOT NULL,
    
	`numberOfArticlesInPeerReviewedOrRefereedJournals` BIGINT,
    `numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst` BIGINT,
    `numberOfPublishedConferencePapers` BIGINT,
    `numberOfPublishedConferencePapersAsFirst` BIGINT,
    `numberOfConferencesAndSymposia` BIGINT,
    `numberOfConferencesAndSymposiaAsFirst` BIGINT,
    `scopusGoogleProfileOfExternalExaminer`TEXT,
    `numberOfPhDsSupervisedOverLastFiveYears` BIGINT,
    `numberOfCurrentPhDStudents` BIGINT,
    `numberOfPHDsCompleted` BIGINT,
    `numberOfMasterDegreeSupervisedOverFiveYears` BIGINT,
    `numberOfCurrentMasterStudents` BIGINT,
    `numberOfMasterDegreeCompleted` BIGINT,
    `nominationOfInternationalExaminer` TEXT,
    `amendmentOfExaminer` TEXT,
    `nominationOfInternalExaminer` TEXT,
    `nominationOfExternalExaminer` TEXT,
    `deviationFromNormalRequirements` TEXT,
    `abbreviatedCurriculumVitaeInformation` TEXT,
    `approvalBody` BIGINT,
    `approvalBodyName` Varchar(255),
    `approvalDate` Date,
    
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    FOREIGN KEY (`userId`) REFERENCES `users`(`id`),
    FOREIGN KEY (`approvalBody`) REFERENCES `examiner_Approval_Body`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20221230114459__Create_EmployeeAdditionalInformationMain () $$ 
DROP PROCEDURE IF EXISTS V20221230114459__Create_EmployeeAdditionalInformationMain $$ 
DELIMITER ;