DELIMITER $$
DROP PROCEDURE IF EXISTS V20230102111642__Create_Flagusers $$
CREATE PROCEDURE V20230102111642__Create_Flagusers()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='flag_users')) THEN 
CREATE TABLE flag_users (
  id bigint NOT NULL AUTO_INCREMENT,
  flagId bigint NOT NULL,
  studentId bigint NOT NULL,
  lastUpdatedBy bigint NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_flag_flagId_idx (flagId) ,
  KEY fk_flag_studentId_idx (studentId) ,
  KEY fk_flag_lastUpdatedBy_idx (lastUpdatedBy),
  CONSTRAINT fk_flag_flagId FOREIGN KEY (flagId) REFERENCES flag (id),
  CONSTRAINT fk_flag_studentId FOREIGN KEY (studentId) REFERENCES students (userId),
  CONSTRAINT fk_flag_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
) ENGINE=InnoDB;

END IF; 

END $$
CALL V20230102111642__Create_Flagusers () $$ 
DROP PROCEDURE IF EXISTS V20230102111642__Create_Flagusers $$ 
DELIMITER ;