DELIMITER $$
DROP PROCEDURE IF EXISTS V20230208121245__Insert_GNA_Receipt_Settlement_Student $$
CREATE PROCEDURE V20230208121245__Insert_GNA_Receipt_Settlement_Student()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Receipt With Settlement' );
IF NOT EXISTS ((SELECT * FROM `report_template` where `reportTypeId`=@reportTypeTempId and `templateCode`='MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE' and `templateName`='GNA Receipt with Settlement Student')) THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES (@reportTypeTempId, 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE', 'GNA Receipt with Settlement Student', 'RECEIPT_WITH_SETTLEMENT_STUDENT_CODE_GNA.png', 'CommonReport_LandScape_SUB.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'RECEIPT_WITH_SETTLEMENT_STUDENT_CODE_GNA.jasper', 'AcademiaLogo.jpg');
END IF;

set @rID = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE');




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_RECEIPT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_RECEIPT_NO', 'Receipt No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_DATE', 'Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_STUDENT_NAME', 'Student Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_FATHER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_FATHER_NAME', 'Father Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ENROLLMENT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ENROLLMENT_NO', 'Enrollment No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_UNIVERSITY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_UNIVERSITY', 'University', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_PROGRAM_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_PROGRAM_NAME', 'Program Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_PROCESSED_BY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_PROCESSED_BY', 'Processed By', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_SR_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_SR_NO', 'Sr. No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_PARTICULAR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_PARTICULAR', 'Particular', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_AMOUNT', 'Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TOTAL_FEES')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TOTAL_FEES', 'Total Fees', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TOTAL_DUE_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TOTAL_DUE_AMOUNT', 'Total due amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_SIGNATURE_OF_DEPOSITOR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_SIGNATURE_OF_DEPOSITOR', 'Signature Of Depositor', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_CASHIER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_CASHIER', 'Cashier', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_MANAGER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_MANAGER', 'Manager', '1', now());
END IF;
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_BANK_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_BANK_NAME', 'Bank Name', '1', now());
END IF;


END $$
CALL V20230208121245__Insert_GNA_Receipt_Settlement_Student() $$
DROP PROCEDURE IF EXISTS V20230208121245__Insert_GNA_Receipt_Settlement_Student $$
DELIMITER ;