DELIMITER $$
DROP PROCEDURE IF EXISTS V20230215122331__Create_lessonPlanningAssessmentSkillCsm $$
CREATE PROCEDURE V20230215122331__Create_lessonPlanningAssessmentSkillCsm()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='lesson_planning_assessment_transferred_skill')) THEN 
CREATE TABLE `lesson_planning_assessment_transferred_skill` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(100) NOT NULL,
	`itemValue` VARCHAR(100) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	UNIQUE KEY itemCode_UNIQUE (itemCode),
    KEY fk_assessment_transferred_skill_lastUpdatedBy_idx (lastUpdatedBy),
    CONSTRAINT fk_lp_assessment_transferred_skill_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'lesson_planning_assessment_transferred_skill')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'lesson_planning_assessment_transferred_skill','LESSON_PLANNING_ASSESSMENT_TRANSFERRED_SKILL','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;


IF  EXISTS ((select * from standard_master where tableName = 'lesson_planning_assessment_transferred_skill')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'lesson_planning_assessment_transferred_skill');
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='ASSESSMENT_TRANSFERRED_SKILL_CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ASSESSMENT_TRANSFERRED_SKILL_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='ASSESSMENT_TRANSFERRED_SKILL_NAME')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ASSESSMENT_TRANSFERRED_SKILL_NAME',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
END IF; 

-- ------------------TRANSLATION-------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'LESSION_PLANNING_TYPE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'LESSION_PLANNING_TYPE', 'Lession Planning Type', 'Lession Planning Type','Tipes lesbeplanning','Các loại kế hoạch bài học',now(),1);
END IF; 

IF NOT EXISTS (select * from ui_translation where ui_translation.objectName='TRANSLATIONS' and keyName='ASSESSMENT_TRANSFERRED_SKILL_CODE') THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`, `lastUpdatedBy`) 
VALUES ( 'TRANSLATIONS', 'ASSESSMENT_TRANSFERRED_SKILL_CODE', 'Assessment Transferred Skill Code','Assessment Transferred Skill Code','Assessering Oorgedra vaardigheidskode','Mã kỹ năng được chuyển giao đánh giá', now(), '1');
END IF;


IF NOT EXISTS (select * from ui_translation where ui_translation.objectName='TRANSLATIONS' and keyName='ASSESSMENT_TRANSFERRED_SKILL_NAME') THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`, `lastUpdatedBy`) 
VALUES ( 'TRANSLATIONS', 'ASSESSMENT_TRANSFERRED_SKILL_NAME', 'Assessment Transferred Skill Name','Assessment Transferred Skill Name','Assessering Oorgedra vaardigheid Naam','Tên kỹ năng được chuyển đánh giá', now(), '1');
END IF; 

END $$
CALL V20230215122331__Create_lessonPlanningAssessmentSkillCsm () $$ 
DROP PROCEDURE IF EXISTS V20230215122331__Create_lessonPlanningAssessmentSkillCsm $$ 
DELIMITER ;