DELIMITER $$
DROP PROCEDURE IF EXISTS V20230503150624__Alter_BusinessRuleConditions $$
CREATE PROCEDURE V20230503150624__Alter_BusinessRuleConditions()
BEGIN
	
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='business_rule_conditions' AND  column_name = 'evaluationPlanLevelOneId')) THEN 
ALTER TABLE `business_rule_conditions`
ADD COLUMN `evaluationPlanLevelOneId` BIGINT(20) NULL DEFAULT NULL AFTER `evaluationPlanId`,
ADD COLUMN `evaluationPlanLevelTwoId` BIGINT(20) NULL DEFAULT NULL AFTER `evaluationPlanLevelOneId`,
ADD COLUMN `evaluationSequenceId` BIGINT(20) NULL DEFAULT NULL AFTER `evaluationPlanLevelTwoId`,
ADD INDEX `fk_BRC_evaluationPlanLevelOneId_idx` (`evaluationPlanLevelOneId` ASC),
ADD INDEX `fk_BRC_evaluationPlanLevelTwoId_idx` (`evaluationPlanLevelTwoId` ASC),
ADD INDEX `fk_BRC_evaluationSequenceId_idx` (`evaluationSequenceId` ASC),

ADD CONSTRAINT `fk_business_rule_conditions_evaluationPlanLevelOneId`
    FOREIGN KEY (`evaluationPlanLevelOneId`)
    REFERENCES `evaluation_plan_level_one` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,

ADD  CONSTRAINT `fk_business_rule_conditions_evaluationPlanLevelTwoId`
    FOREIGN KEY (`evaluationPlanLevelTwoId`)
    REFERENCES `evaluation_plan_level_two` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    
ADD  CONSTRAINT `fk_business_rule_conditions_evaluationSequenceId`
    FOREIGN KEY (`evaluationSequenceId`)
    REFERENCES `evaluation_sequence` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION;
END IF; 
END $$
CALL V20230503150624__Alter_BusinessRuleConditions() $$
DROP PROCEDURE IF EXISTS V20230503150624__Alter_BusinessRuleConditions $$
DELIMITER ;