DELIMITER $$
DROP PROCEDURE IF EXISTS V20230620172205__Create_business_rule_hostel_mapping $$
CREATE PROCEDURE V20230620172205__Create_business_rule_hostel_mapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='business_rule_hostel_mapping')) THEN 
CREATE TABLE `business_rule_hostel_mapping` (
`id` BIGINT NOT NULL AUTO_INCREMENT,
  `brId` BIGINT NOT NULL,
  `hostelId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT now(),
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `brId_idx` (`brId` ASC) ,
  INDEX `hostelId_idx` (`hostelId` ASC) ,
  CONSTRAINT `brId`
    FOREIGN KEY (`brId`)
    REFERENCES `business_rule` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `hostelId`
    FOREIGN KEY (`hostelId`)
    REFERENCES `hostel` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_business_rule_hostel_mapping_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
  );
END IF; 

END $$
CALL V20230620172205__Create_business_rule_hostel_mapping () $$ 
DROP PROCEDURE IF EXISTS V20230620172205__Create_business_rule_hostel_mapping $$ 
DELIMITER ;