DELIMITER $$
DROP PROCEDURE IF EXISTS `rpt_admissionSummaryApprovalDate` $$
CREATE PROCEDURE rpt_admissionSummaryApprovalDate(academyLocation text, intakeYear int(10), StartDate date, EndDate date, ProgramCategory varchar(5), ProgramGroup  varchar(5), seatType text)
BEGIN
declare StartDateNull, EndDateNull, ProgramCategoryNull, ProgramGroupNull, seatTypeNull,academyLocation boolean;
 declare no_more_rows boolean default false;
   declare cur_Brand_Campus_ID, cur_alId,cur_programid,cur_programSequence,cur_seattypeid,cur_tot_admissions, cur_tot_weekly_admissions,cur_target_for_admission,
  cur_totalSuccessfulApplications,cur_prev_tot_admissions int default 0;
 DECLARE cur_Brand_Campus,cur_grade VARCHAR(500);
 declare cur_Perc_Target_Admission,cur_conv_perc,cur_YOY_Variance_for_total_Admissions_target double default 0;
 
   call str_to_row (academyLocation);
   call str_to_row_seattype (seatType);
   
 if StartDate is null then
  	set StartDateNull = 1;
   else set StartDateNull = 0;
   end if;
   if EndDate is null then
  	set EndDateNull = 1;
   else set EndDateNull = 0;
   end if;
   if ProgramCategory is null then
  	set ProgramCategoryNull = 1;
   else set ProgramCategoryNull = 0;
   end if;
   if ProgramGroup is null then
  	set ProgramGroupNull = 1;
   else set ProgramGroupNull = 0;
   end if;
   if (seatType is null or seatType='')then
  	set seatTypeNull = 1;
   else set seatTypeNull = 0;
   end if;
   if (academyLocation is null or academyLocation='')then
  	set academyLocation = 1;
   else set academyLocation = 0;
   end if;
   
   drop table if exists tbl_admissionSummaryApprovalDate;
   create table tbl_admissionSummaryApprovalDate(
   Brand_Campus text, Brand_Campus_ID long, programId long, grade varchar(500),programSequence int  default 0,Total_Admission int default 0, Weekly_movement_Admission int default 0,
   Target_for_admission int default 0,Perc_Target_Admission double default 0,totalSuccessfulApplications int default 0,conversion_perc_assessment double default 0,prev_yr_tot_admission int default 0
   ,YOY_Variance_for_total_Admissions_target double default 0);


START TRANSACTION;
BLOCK1: begin
DECLARE cur1 CURSOR FOR 
select concat(al.academyName, '-', al.locationName), al.id, p.id, p.programNameToBePrint,p.programSequence,absc.seattypeid
  	from prog_batch_seat_config as absc 
	join batches as b on absc.programBatchId = b.id
	join programs as p on b.programId=p.id and p.status = 'O' and p.programClosureDate is null
	join academy_location as al on p.academyLocationId = al.id
    where
	(al.id in (select s from tbl_str_to_row) or 1= academyLocation)and b.intakeYearId = intakeYear
  	and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  	and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
    and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
  	group by al.id, p.id;
        	
declare continue handler for not found  set no_more_rows := true;

OPEN cur1;

 read_loop: LOOP
 
 FETCH cur1 INTO cur_Brand_Campus,cur_alId,cur_programid,cur_grade,cur_programSequence,cur_seattypeid;
 
 if no_more_rows then set no_more_rows := false;
        close cur1;
        leave read_loop;
end if; 

   
set cur_tot_admissions:=(select count(distinct a.id) as tot_admissions
  	from admission as a
    join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		join programs p on p.id = b.programId
  	where
  		 (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
 		and	(date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
        and a.academyLocationId = cur_alId and p.id = cur_programid
  	group by a.academyLocationId, p.id);
    if no_more_rows then set cur_tot_admissions=0;set no_more_rows=false; end if; 
    
    
set cur_tot_weekly_admissions:=(select count(distinct a.id) as tot_weekly_admissions
from admission as a 
join academy_location_purpose alp on a.academyLocationId = alp.academyLocationId
join calendars on alp.calendarId = calendars.id 
join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
join batches as b on a.batchId = b.id and b.intakeYearId = intakeYear
join programs as p on p.id = b.programId
where date(aad.admissionApprovedOn) between (date_sub(current_date(), interval WEEKDAY(current_date()) - (case when weekStart = 'MONDAY' then 0
	when weekStart = 'TUESDAY' then 1 when weekStart = 'WEDNESDAY' then 2
	when weekStart = 'THURSDAY' then 3 when weekStart = 'FRIDAY' then 4
	when weekStart = 'SATURDAY' then 5 end) day)) and current_date()
and 
(p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
and	(date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
and a.academyLocationId = cur_alId and p.id = cur_programid
group by a.academyLocationId, p.id);
if no_more_rows then set cur_tot_weekly_admissions=0;set no_more_rows=false; end if; 

 set cur_target_for_admission= (select (b.seatCapacity - count(distinct a.Id)) as target_for_admission
	   	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id 
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		join programs p on p.id = b.programId
  	where 
		(p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
		and	(date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
		and a.status in ('ADMISSION_CONFIRMED', 'ADMITTED_PROVISIONALLY')
        and a.academyLocationId = cur_alId and p.id = cur_programid
	group by p.id, b.id);
    if no_more_rows then set cur_target_for_admission=0;set no_more_rows=false; end if; 


   set cur_Perc_Target_Admission=ifnull(cur_tot_admissions / NULLIF(cur_target_for_admission,0) * 100,0);
   
   
select  apl.Total_SUCCESSFUL_Admission,(adm.tot_admissions / ifnull(apl.Total_SUCCESSFUL_Admission, 1) * 100) into cur_totalSuccessfulApplications, cur_conv_perc
   from
   (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, aad.admissionApprovedOn, b.startDate, b.tillDate
	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id 
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		join programs p on p.id = b.programId
  	where 
			(date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
			and	(date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
  			and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  			and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
            and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
  			 group by a.academyLocationId, p.id) as adm join
  	(Select al.id, p.id as grade_id, count(distinct a.id) as Total_SUCCESSFUL_Admission
  		from application a right join application_program ap on a.id=ap.applicationId
  		left join programs p on p.id = ap.programId
  		left join academy_location al on al.id = ap.academyLocationId 
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id 
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
  		where a.currentStatus in ('APPROVED','ADMISSION_GRANTED','DIRECT_SUBMISSION_TOKEN_GENERATED','SOLD,FORM_SALE_TOKEN_GENERATED','DIRECT_ADMISSION')
  		and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
 		and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
        and al.id=cur_alId and  p.id=cur_programid
		 group by al.id, p.id) apl
  	on adm.academyLocationId = apl.id and adm.grade_id = apl.grade_id;

if no_more_rows then set cur_totalSuccessfulApplications=0; set cur_conv_perc=0; set no_more_rows=false; end if;


select prev_yr_admission.tot_admissions ,ifnull(((curr_yr_admission.tot_admissions - prev_yr_admission.tot_admissions)/NULLIF(prev_yr_admission.tot_admissions,0) * 100),0) into 
   cur_prev_tot_admissions,cur_YOY_Variance_for_total_Admissions_target
   from
   (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, aad.admissionApprovedOn
	   	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id 
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = (select id from intake_year 
	where itemValue = (select itemValue - 1 from intake_year where id = intakeYear))
		join programs p on p.id = b.programId
  	where
		(p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
		and	(date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
  		group by a.academyLocationId, p.id) as prev_yr_admission
   join (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, aad.admissionApprovedOn
 	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		join programs p on p.id = b.programId
  	where 
        (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
		and	(date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
          and a.academyLocationId=cur_alId and  p.id=cur_programid
  		group by a.academyLocationId, p.id) as curr_yr_admission
   on prev_yr_admission.academyLocationId = curr_yr_admission.academyLocationId
   and prev_yr_admission.grade_id = curr_yr_admission.grade_id;
   
if no_more_rows then set cur_prev_tot_admissions=0; set cur_YOY_Variance_for_total_Admissions_target=0; set no_more_rows=false; end if; 

  insert into tbl_admissionSummaryApprovalDate values(cur_Brand_Campus,cur_alId,cur_programid,cur_grade,cur_programSequence,cur_tot_admissions,cur_tot_weekly_admissions,cur_target_for_admission,
  cur_Perc_Target_Admission,cur_totalSuccessfulApplications,cur_conv_perc,cur_prev_tot_admissions,cur_YOY_Variance_for_total_Admissions_target);

END loop read_loop;

  select Brand_Campus_ID as academyLocationId, Brand_Campus as academyLocationName
  	, programId, grade as programName, Total_Admission as totalAdmission
  	, Weekly_movement_Admission as WMofAdmission, conversion_perc_assessment as ConPercFromAs
  	, Target_for_admission as targetForAdmission, Perc_Target_Admission as perOfTargetForAdmission
  	, YOY_Variance_for_total_Admissions_target as yoyTotalAdmission, prev_yr_tot_admission as prevTotalAdmission, totalSuccessfulApplications,programSequence
   from tbl_admissionSummaryApprovalDate order by Brand_Campus,programSequence; 

END BLOCK1;
commit;

END $$
DELIMITER ;
