DELIMITER $$
DROP PROCEDURE IF EXISTS V20230706123438__Create_ProgramWithdrawalMultiResaon $$
CREATE PROCEDURE V20230706123438__Create_ProgramWithdrawalMultiResaon()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_withdrawl_request_multiple_reason')) THEN 
 CREATE TABLE `program_withdrawl_request_multiple_reason` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `programWithdrawlRequestDetailId` BIGINT(20) NOT NULL,
  `programWithdrawlReasonId` BIGINT(20) NULL,
  `reasonRemark` longtext NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_prog_withdraw_multiple_reason_request_detail_idx` (`programWithdrawlRequestDetailId` ASC),
  INDEX `fk_prog_withdraw_request_multiple_reason_pw_reason_idx` (`programWithdrawlReasonId` ASC),
  INDEX `fk_prog_withdraw_request_multiple_reason_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_prog_withdraw_multiple_reason_terminationRequestDetail_id`
    FOREIGN KEY (`programWithdrawlRequestDetailId`)
    REFERENCES `program_withdraw_req_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_prog_withdraw_request_multiple_reason_pw_reason_id`
    FOREIGN KEY (`programWithdrawlReasonId`)
    REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_program_withdrawal_request_multiple_reasons_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF;  

END $$
CALL V20230706123438__Create_ProgramWithdrawalMultiResaon () $$ 
DROP PROCEDURE IF EXISTS V20230706123438__Create_ProgramWithdrawalMultiResaon $$ 
DELIMITER ;