DELIMITER $$
DROP PROCEDURE IF EXISTS V20230727115814__Update_PaymentTermSubmissionRecepients $$
CREATE PROCEDURE V20230727115814__Update_PaymentTermSubmissionRecepients()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='PAYMENT_TERM_SUBMISSION_RECIPIENTS')) THEN 
SET @enqVelRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PAYMENT_TERM_SUBMISSION_RECIPIENTS');
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
     T1.studentId AS ID,
     T6.`salutationName` AS SALUTATION_NAME,
     T3.`firstName` AS FIRST_NAME,
     T3.`middleName` AS MIDDLE_NAME,
     T3.`lastName` AS LAST_NAME,
     Father.`emailId` AS EMAIL_ID,
 	Father.`mobileNumber` AS MOBILE_NO,
     Father.`firstName` AS PARENT_FIRSTNAME,
     Father.`lastName` AS PARENT_LASTNAME,
     Father.`mobileCountryCode` AS MOBILE_CODE,
     T8.`displayName` AS ACADEMY_NAME_LOCATION,
 	 T8.id AS ACADEMY_LOCATION_ID,
     T8.path AS ACADEMY_LOCATION_LOGO ,
     T1.whetherAllowedPhotoForYearBookAndNewsletter AS ALLOW_NEWSLETTER_YEARBOOK,
     T1.whetherAllowedPhotoForSocialMedia AS ALLOW_SOCIAL_MEDIA,
     t6.scheme AS MEDICAL_SCHEME,
     t6.option1 AS MEDICAL_OPTION,
     t6.principleMember AS MEDICAL_PRINCIPLE_MEMBER,
     t6.membershipNumber AS MEDICAL_MEMBERSHIP_NUMBER,
     t6.validTill AS MEDICAL_VALID_TILL,
     t6.bloodType AS MEDICAL_BLOOD_TYPE,
     t6.childDependentCode AS MEDICAL_CHILD_DEPENDENT_CODE,
     t6.familyPractionerName AS MEDICAL_FAMILY_PRACTIONER_NAME,
     t6.familyPractionerCountryCode AS MEDICAL_FAMILY_PRACTIONER_COUNTRY_CODE,
     t6.familyPractionerContactNumber AS MEDICAL_FAMILY_PRACTIONER_CONTACT_NUMBER,
     t7.path AS MEDICAL_DOCUMENT,
     (case when t5.feePlanName is not null then (select t22.feePlanName from parent_payment_term_settings t11 
     left outer join fee_plan t22 on t22.id=t11.feePlanId where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=2 limit 0,1) else null end) as FEE_PLAN_NAME_PROGRAM,
     
     (case when t2.feeRuleDesc is not null then (select t33.feeRuleDesc from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=2 limit 0,1) else null end) as FEE_PLAN_RULE_PROGRAM,
        
	 (case when t4.feeAmount is not null then (select t55.feeAmount from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
        left outer join fee_plan_rule_stage t44 on t44.feePlanRuleId=t33.id left outer join fee_stage_head_config t55 on t55.feePlanRuleStageId=t44.id
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=2 group by t22.id limit 0,1) else null end) as FEE_PLAN_AMOUNT_PROGRAM,
        
	(case when t5.feePlanName is not null then (select t22.feePlanName from parent_payment_term_settings t11 
     left outer join fee_plan t22 on t22.id=t11.feePlanId where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 limit 0,1) else null end) as FEE_PLAN_NAME_SERVICE1,
     
     (case when t2.feeRuleDesc is not null then (select t33.feeRuleDesc from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 limit 0,1) else null end) as FEE_PLAN_RULE_SERVICE1,
        
	 (case when t4.feeAmount is not null then (select t55.feeAmount from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
        left outer join fee_plan_rule_stage t44 on t44.feePlanRuleId=t33.id left outer join fee_stage_head_config t55 on t55.feePlanRuleStageId=t44.id
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 group by t22.id limit 0,1) else null end) as FEE_PLAN_AMOUNT_SERVICE1,
     
	(case when t5.feePlanName is not null then (select t22.feePlanName from parent_payment_term_settings t11 
     left outer join fee_plan t22 on t22.id=t11.feePlanId where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 limit 1,1) else null end) as FEE_PLAN_NAME_SERVICE2,
     
     (case when t2.feeRuleDesc is not null then (select t33.feeRuleDesc from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 limit 1,1) else null end) as FEE_PLAN_RULE_SERVICE2,
        
	 (case when t4.feeAmount is not null then (select t55.feeAmount from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
        left outer join fee_plan_rule_stage t44 on t44.feePlanRuleId=t33.id left outer join fee_stage_head_config t55 on t55.feePlanRuleStageId=t44.id
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 group by t22.id limit 1,1) else null end) as FEE_PLAN_AMOUNT_SERVICE2,
     
	(case when t5.feePlanName is not null then (select t22.feePlanName from parent_payment_term_settings t11 
     left outer join fee_plan t22 on t22.id=t11.feePlanId where t11.studentId in(namedParams)  and t11.isLatestRegistration=true and t22.feePlanType=3 limit 2,1) else null end) as FEE_PLAN_NAME_SERVICE3,
     
	(case when t2.feeRuleDesc is not null then (select t33.feeRuleDesc from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 limit 2,1) else null end) as FEE_PLAN_RULE_SERVICE3,
    
     (case when t4.feeAmount is not null then (select t55.feeAmount from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
        left outer join fee_plan_rule_stage t44 on t44.feePlanRuleId=t33.id left outer join fee_stage_head_config t55 on t55.feePlanRuleStageId=t44.id
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 group by t22.id limit 2,1) else null end) as FEE_PLAN_AMOUNT_SERVICE3 ,
    
    (case when t5.feePlanName is not null then (select t22.feePlanName from parent_payment_term_settings t11 
     left outer join fee_plan t22 on t22.id=t11.feePlanId where t11.studentId in(namedParams)  and t11.isLatestRegistration=true and t22.feePlanType=3 limit 3,1) else null end) as FEE_PLAN_NAME_SERVICE4,
     
	(case when t2.feeRuleDesc is not null then (select t33.feeRuleDesc from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 limit 3,1) else null end) as FEE_PLAN_RULE_SERVICE4,
    
     (case when t4.feeAmount is not null then (select t55.feeAmount from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
        left outer join fee_plan_rule_stage t44 on t44.feePlanRuleId=t33.id left outer join fee_stage_head_config t55 on t55.feePlanRuleStageId=t44.id
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 group by t22.id limit 3,1) else null end) as FEE_PLAN_AMOUNT_SERVICE4,
    
     (case when t5.feePlanName is not null then (select t22.feePlanName from parent_payment_term_settings t11 
     left outer join fee_plan t22 on t22.id=t11.feePlanId where t11.studentId in(namedParams)  and t11.isLatestRegistration=true and t22.feePlanType=3 limit 4,1) else null end) as FEE_PLAN_NAME_SERVICE5,
     
	(case when t2.feeRuleDesc is not null then (select t33.feeRuleDesc from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 limit 4,1) else null end) as FEE_PLAN_RULE_SERVICE5,
    
     (case when t4.feeAmount is not null then (select t55.feeAmount from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
        left outer join fee_plan_rule_stage t44 on t44.feePlanRuleId=t33.id left outer join fee_stage_head_config t55 on t55.feePlanRuleStageId=t44.id
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 group by t22.id limit 4,1) else null end) as FEE_PLAN_AMOUNT_SERVICE5,
        
     (case when t5.feePlanName is not null then (select t22.feePlanName from parent_payment_term_settings t11 
     left outer join fee_plan t22 on t22.id=t11.feePlanId where t11.studentId in(namedParams)  and t11.isLatestRegistration=true and t22.feePlanType=3 limit 5,1) else null end) as FEE_PLAN_NAME_SERVICE6,
     
	(case when t2.feeRuleDesc is not null then (select t33.feeRuleDesc from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 limit 5,1) else null end) as FEE_PLAN_RULE_SERVICE6,
    
     (case when t4.feeAmount is not null then (select t55.feeAmount from parent_payment_term_settings t11 
		left outer join fee_plan t22 on t22.id=t11.feePlanId left outer join fee_plan_rules t33 on t11.feeRuleId=t33.id 
        left outer join fee_plan_rule_stage t44 on t44.feePlanRuleId=t33.id left outer join fee_stage_head_config t55 on t55.feePlanRuleStageId=t44.id
		where t11.studentId in(namedParams) and t11.isLatestRegistration=true and t22.feePlanType=3 group by t22.id limit 5,1) else null end) as FEE_PLAN_AMOUNT_SERVICE6   
     

 FROM
     parent_payment_term_settings T1
         LEFT OUTER JOIN
     students T2 ON T2.userId = T1.studentId
         LEFT OUTER JOIN
     persons T3 ON T3.id = T2.personId
         LEFT JOIN
     salutations T6 ON T6.id = T3.salutationId
         LEFT OUTER JOIN
     person_relationships T4 ON T4.personId = T3.id
         LEFT OUTER JOIN
     persons Father ON Father.id = T4.relatedPersonId
 		LEFT OUTER JOIN
 	admission T7 on T7.studentId = T2.userId
 		LEFT OUTER JOIN
 	academy_location T8 on T8.id=T7.academyLocationId
		LEFT OUTER JOIN 
	fee_plan_rules t2 on t2.id=T1.feeRuleId 
		LEFT OUTER JOIN 
	fee_plan_rule_stage t3 on t3.feePlanRuleId=t2.id
		LEFT OUTER JOIN 
	fee_stage_head_config t4 on t4.feePlanRuleStageId=t3.id
		LEFT OUTER JOIN 
	fee_plan t5 on t5.id=T1.feePlanId
		LEFT OUTER JOIN
	medical_details t6 on T1.medicalDetail=t6.id
		LEFT OUTER JOIN
    documents t7 on t6.medicalAidDocument=t7.id 
 WHERE
     T4.relationship = 'FATHER' AND T1.studentId in (namedParams) and T1.isLatestRegistration=true and T7.activeStatus=true group by T1.studentId",
    `jsonString` ='{
     "id": 1,
     "searchResultViewColumns": [
         {
             "id": 3,
             "value": "firstName",
             "resultKey": "FIRST_NAME",
             "displayCode": "",
             "displayOrder": 2
         },
         {
             "id": 4,
             "value": "middleName",
             "resultKey": "MIDDLE_NAME",
             "displayCode": "",
             "displayOrder": 3
         },
         {
             "id": 5,
             "value": "lastName",
             "resultKey": "LAST_NAME",
             "displayCode": "",
             "displayOrder": 4
         },
         {
             "id": 6,
             "value": "emailId",
             "resultKey": "EMAIL_ID",
             "displayCode": "",
             "displayOrder": 5
         },
         {
             "id": 7,
             "value": "mobileNumber",
             "resultKey": "MOBILE_NO",
             "displayCode": "",
             "displayOrder": 6
         },		 
 		{
             "id": 8,
             "value": "firstName",
             "resultKey": "PARENT_FIRSTNAME",
             "displayCode": "",
             "displayOrder": 7
         },
 		{
             "id": 9,
             "value": "lastName",
             "resultKey": "PARENT_LASTNAME",
             "displayCode": "",
             "displayOrder": 8
         },
 		{
             "id": 10,
             "value": "displayName",
             "resultKey": "ACADEMY_NAME_LOCATION",
             "displayCode": "",
             "displayOrder": 9
         },
           { 
  			 "id": 11,
               "value": "academyId",
               "resultKey": "ACADEMY_LOCATION_ID",
               "displayCode": "",
               "displayOrder": 10
           }
		  ,
           { 
  			 "id": 12,
               "value": "whetherAllowedPhotoForYearBookAndNewsletter",
               "resultKey": "ALLOW_NEWSLETTER_YEARBOOK",
               "displayCode": "",
               "displayOrder": 11
           } 
		   ,
           { 
  			 "id": 13,
               "value": "whetherAllowedPhotoForSocialMedia",
               "resultKey": "ALLOW_SOCIAL_MEDIA",
               "displayCode": "",
               "displayOrder": 12
           } 
		   ,
           { 
  			 "id": 14,
               "value": "scheme",
               "resultKey": "MEDICAL_SCHEME",
               "displayCode": "",
               "displayOrder": 13
           } 
		   ,
           { 
  			 "id": 15,
               "value": "option1",
               "resultKey": "MEDICAL_OPTION",
               "displayCode": "",
               "displayOrder": 14
           } 
		    ,
           { 
  			 "id": 16,
               "value": "principleMember",
               "resultKey": "MEDICAL_PRINCIPLE_MEMBER",
               "displayCode": "",
               "displayOrder": 15
           } 
		   ,
           { 
  			 "id": 17,
               "value": "membershipNumber",
               "resultKey": "MEDICAL_MEMBERSHIP_NUMBER",
               "displayCode": "",
               "displayOrder": 16
           } 
		    ,
           { 
  			 "id": 18,
               "value": "validTill",
               "resultKey": "MEDICAL_VALID_TILL",
               "displayCode": "",
               "displayOrder": 17
           } 
		   ,
           { 
  			 "id": 19,
               "value": "bloodType",
               "resultKey": "MEDICAL_BLOOD_TYPE",
               "displayCode": "",
               "displayOrder": 18
           } 
		    ,
           { 
  			 "id": 20,
               "value": "childDependentCode",
               "resultKey": "MEDICAL_CHILD_DEPENDENT_CODE",
               "displayCode": "",
               "displayOrder": 19
           } 
		    ,
           { 
  			 "id": 21,
               "value": "familyPractionerName",
               "resultKey": "MEDICAL_FAMILY_PRACTIONER_NAME",
               "displayCode": "",
               "displayOrder": 20
           } 
		     ,
           { 
  			 "id": 22,
               "value": "familyPractionerCountryCode",
               "resultKey": "MEDICAL_FAMILY_PRACTIONER_COUNTRY_CODE",
               "displayCode": "",
               "displayOrder": 21
           } 
		    ,
           { 
  			 "id": 23,
               "value": "familyPractionerContactNumber",
               "resultKey": "MEDICAL_FAMILY_PRACTIONER_CONTACT_NUMBER",
               "displayCode": "",
               "displayOrder": 22
           } 
		     ,
           { 
  			 "id": 24,
               "value": "path",
               "resultKey": "MEDICAL_DOCUMENT",
               "displayCode": "",
               "displayOrder": 23
           } 
		     ,
           { 
  			 "id": 25,
               "value": "feePlanName",
               "resultKey": "FEE_PLAN_NAME_PROGRAM",
               "displayCode": "",
               "displayOrder": 24
           } 
		    ,
           { 
  			 "id": 26,
               "value": "feeRuleDesc",
               "resultKey": "FEE_PLAN_RULE_PROGRAM",
               "displayCode": "",
               "displayOrder": 25
           } 
		     ,
           { 
  			 "id": 27,
               "value": "feeAmount",
               "resultKey": "FEE_PLAN_AMOUNT_PROGRAM",
               "displayCode": "",
               "displayOrder": 26
           } 
		      ,
           { 
  			 "id": 28,
               "value": "feePlanName",
               "resultKey": "FEE_PLAN_NAME_SERVICE1",
               "displayCode": "",
               "displayOrder": 27
           } 
		    ,
           { 
  			 "id": 29,
               "value": "feeRuleDesc",
               "resultKey": "FEE_PLAN_RULE_SERVICE1",
               "displayCode": "",
               "displayOrder": 28
           } 
		     ,
           { 
  			 "id": 30,
               "value": "feeAmount",
               "resultKey": "FEE_PLAN_AMOUNT_SERVICE1",
               "displayCode": "",
               "displayOrder": 29
           } 
		     ,
           { 
  			 "id": 31,
               "value": "feePlanName",
               "resultKey": "FEE_PLAN_NAME_SERVICE2",
               "displayCode": "",
               "displayOrder": 30
           } 
		    ,
           { 
  			 "id": 32,
               "value": "feeRuleDesc",
               "resultKey": "FEE_PLAN_RULE_SERVICE2",
               "displayCode": "",
               "displayOrder": 31
           } 
		     ,
           { 
  			 "id": 33,
               "value": "feeAmount",
               "resultKey": "FEE_PLAN_AMOUNT_SERVICE2",
               "displayCode": "",
               "displayOrder": 32
           } 
		   ,
           { 
  			 "id": 34,
               "value": "feePlanName",
               "resultKey": "FEE_PLAN_NAME_SERVICE3",
               "displayCode": "",
               "displayOrder": 33
           } 
		    ,
           { 
  			 "id": 35,
               "value": "feeRuleDesc",
               "resultKey": "FEE_PLAN_RULE_SERVICE3",
               "displayCode": "",
               "displayOrder": 34
           } 
		     ,
           { 
  			 "id": 36,
               "value": "feeAmount",
               "resultKey": "FEE_PLAN_AMOUNT_SERVICE3",
               "displayCode": "",
               "displayOrder": 35
           } 
		    ,
           { 
  			 "id": 37,
               "value": "feePlanName",
               "resultKey": "FEE_PLAN_NAME_SERVICE4",
               "displayCode": "",
               "displayOrder": 36
           } 
		    ,
           { 
  			 "id": 38,
               "value": "feeRuleDesc",
               "resultKey": "FEE_PLAN_RULE_SERVICE4",
               "displayCode": "",
               "displayOrder": 37
           } 
		     ,
           { 
  			 "id": 39,
               "value": "feeAmount",
               "resultKey": "FEE_PLAN_AMOUNT_SERVICE4",
               "displayCode": "",
               "displayOrder": 38
           } 
		     ,
           { 
  			 "id": 40,
               "value": "feePlanName",
               "resultKey": "FEE_PLAN_NAME_SERVICE5",
               "displayCode": "",
               "displayOrder": 39
           } 
		    ,
           { 
  			 "id": 41,
               "value": "feeRuleDesc",
               "resultKey": "FEE_PLAN_RULE_SERVICE5",
               "displayCode": "",
               "displayOrder": 40
           } 
		     ,
           { 
  			 "id": 42,
               "value": "feeAmount",
               "resultKey": "FEE_PLAN_AMOUNT_SERVICE5",
               "displayCode": "",
               "displayOrder": 41
           } 
		      ,
           { 
  			 "id": 43,
               "value": "feePlanName",
               "resultKey": "FEE_PLAN_NAME_SERVICE6",
               "displayCode": "",
               "displayOrder": 42
           } 
		    ,
           { 
  			 "id": 44,
               "value": "feeRuleDesc",
               "resultKey": "FEE_PLAN_RULE_SERVICE6",
               "displayCode": "",
               "displayOrder": 43
           } 
		     ,
           { 
  			 "id": 45,
               "value": "feeAmount",
               "resultKey": "FEE_PLAN_AMOUNT_SERVICE6",
               "displayCode": "",
               "displayOrder": 44
           } 
     ]
 }' WHERE (`dataProviderId` = @enqVelRecId);
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230727115814__Update_PaymentTermSubmissionRecepients () $$
DROP PROCEDURE IF EXISTS V20230727115814__Update_PaymentTermSubmissionRecepients $$
DELIMITER ;