DELIMITER $$
DROP PROCEDURE IF EXISTS V20230809125701__Create_pandaDocDetails $$
CREATE PROCEDURE V20230809125701__Create_pandaDocDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_pandadoc_document_details')) THEN 
CREATE TABLE applicant_pandadoc_document_details (
  id bigint NOT NULL AUTO_INCREMENT,
  applicationId bigint NOT NULL,
  documentName varchar(255),
  documentId varchar(255),
  templateName varchar(255),
  templateId varchar(255),
  docStatus varchar(255),
  sendDate date,
  lastUpdatedBy bigint NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_pandadoc_applicantId_idx (applicationId) ,
  KEY fk_pandadoc_lastUpdatedBy_idx (lastUpdatedBy),
  CONSTRAINT fk_pandadoc_applicantId FOREIGN KEY (applicationId) REFERENCES application (id),
  CONSTRAINT fk_pandadoc_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
) ENGINE=InnoDB;

END IF; 

END $$
CALL V20230809125701__Create_pandaDocDetails () $$ 
DROP PROCEDURE IF EXISTS V20230809125701__Create_pandaDocDetails $$ 
DELIMITER ;