DELIMITER $$
DROP PROCEDURE IF EXISTS V20230817124757__Insert_dydt_line_items_hostel $$
CREATE PROCEDURE V20230817124757__Insert_dydt_line_items_hostel()
BEGIN

IF NOT EXISTS ((select * from dydt_data_line_item where dataSourceCode='APPLICANT_HOSTEL_DETAILS_INFO')) THEN 
SET @dydtdataproviderId=(SELECT id FROM `dydt_data_provider` where providerName='Applicant Hostel Details');
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, 
`whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'APPLICANT_HOSTEL_DETAILS_INFO', '1',null, '1', '1', 
"SELECT 
T1.id AS id,
T2.firstName AS applicant_first_name,
T2.middleName AS applicant_middle_name,
T2.lastName AS applicant_last_name,
T3.code as applicant_id,
T3.primaryEmailId AS applicant_primary_email_id,
CONCAT(T2.mobileCountryCode,T2.mobileNumber) AS applicant_mobile_no,
T2.birthDate AS applicant_dob,
T7.displayName AS academy_location_print_name,
T9.addressText AS academy_location_address_box_postal_address,
T11.countryName AS academy_location_country_postal_address,
T10.countryRegionName AS academy_location_country_region_postal_address,
T12.cityName AS academy_location_city_postal_address,
T9.pincode AS academy_location_pincode_postal_address,
T1.offerLetterIssueDate AS offer_letter_issue_date,
T1.offerLetterExpiryDate AS offer_letter_expiry_date,
T1.hostelFeeAmount AS fee_amount,
T7.logoUrl AS img_academy_location_logo,
T7.headerUrl AS img_header_url,
T7.footerUrl AS img_footer_url,
T4.itemValue AS hostel_student_category_csm,
T6.locationName AS location,
T5.categoryCode AS reservation_category_csm
from hostel_offer_detail T1
left join applicant_person T2 on T2.id=T1.applicantPersonId
left join application T3 on T3.applicantPersonId=T2.id
left join hostel_student_category T4 on T4.id=T1.hostelStudentCategoryId
left join reservation_category T5 on T5.id=T1.reservationCategoryId
left join locations T6 on T6.id =T1.locationId
left join academy_location T7 on T7.id =T3.issuedFromAcademyLocation
left join academy_location_addresses T8 on T8.academyLocationId =T7.id
left join address T9 on T8.addressId =T9.id AND T9.addressTypeId=11
left join country_region T10 on T10.id =T9.parentRegionId 
left join country T11 on T10.countryId =T11.id
left join city T12 on T12.id =T9.cityId
",
    'PRM_HOSTEL_OFFER_DETAIL_ID', 
    'applicant_first_name,applicant_middle_name,applicant_last_name,applicant_id,applicant_primary_email_id,applicant_mobile_no,applicant_dob,
    academy_location_print_name,academy_location_address_box_postal_address,academy_location_country_postal_address,
academy_location_country_region_postal_address,academy_location_city_postal_address,academy_location_pincode_postal_address,offer_letter_issue_date,offer_letter_expiry_date,
fee_amount,img_academy_location_logo,img_header_url,img_footer_url,hostel_student_category_csm,location,reservation_category_csm,', 
    'where T1.id=PRM_HOSTEL_OFFER_DETAIL_ID','0');

#------------------TRANSLATIONS---------------------
   
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('applicant_first_name', 'Applicant First Name',@dydtdatalinitemId+1),
    ('applicant_middle_name', 'Applicant Middle Name',@dydtdatalinitemId+1),
    ('applicant_last_name', 'Applicant Last Name',@dydtdatalinitemId+1),
    ('applicant_id', 'Applicant ID',@dydtdatalinitemId+1),
    ('applicant_primary_email_id', 'Applicant Primary Email ID',@dydtdatalinitemId+1),
    ('applicant_mobile_no', 'Applicant Mobile No.',@dydtdatalinitemId+1),
    ('applicant_dob', 'Applicant Date of birth',@dydtdatalinitemId+1),
    
    ('academy_location_print_name', 'Academy location print name',@dydtdatalinitemId+1),
    ('academy_location_address_box_postal_address', 'Academy Location Address Box-Postal Address',@dydtdatalinitemId+1),
    ('academy_location_country_postal_address', 'Academy Location Country-Postal Address',@dydtdatalinitemId+1),
    
    ('academy_location_country_region_postal_address', 'Academy Location Country Region-Postal Address',@dydtdatalinitemId+1),
    ('academy_location_city_postal_address', 'Academy Location City-Postal Address',@dydtdatalinitemId+1),
    ('academy_location_pincode_postal_address', 'Academy Location Pin Code-Postal Address',@dydtdatalinitemId+1),
    ('offer_letter_issue_date', 'Offer Letter Issue Date',@dydtdatalinitemId+1),
    ('offer_letter_expiry_date', 'Offer Letter Expiry Date',@dydtdatalinitemId+1),
    
    ('fee_amount', 'Fee Amount',@dydtdatalinitemId+1),
    ('img_academy_location_logo', 'Academy location logo',@dydtdatalinitemId+1),
    ('img_header_url', 'Header URL',@dydtdatalinitemId+1),
    ('img_footer_url', 'Footer URL',@dydtdatalinitemId+1),
    ('hostel_student_category_csm', 'Student Category-CSM',@dydtdatalinitemId+1),
    ('location', 'Location',@dydtdatalinitemId+1),
    ('reservation_category_csm', 'Reservation category-CSM',@dydtdatalinitemId+1);

END IF; 

END $$
CALL V20230817124757__Insert_dydt_line_items_hostel() $$
DROP PROCEDURE IF EXISTS V20230817124757__Insert_dydt_line_items_hostel $$
DELIMITER ;