DELIMITER $$
DROP PROCEDURE IF EXISTS V20230817130333__Insert_ApplicantHealthDataGrid $$
CREATE PROCEDURE V20230817130333__Insert_ApplicantHealthDataGrid()
BEGIN

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.personinfo.common.pasthistory.ApplicantHealthInformationGrid' and portalId=1)) THEN 
INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
('Academia.view.personinfo.common.pasthistory.ApplicantHealthInformationGrid',1,
'[{"id":null,"columnName":"MEDICAL_CONDITIONS","dataIndex":"MedicalConditionsNameVal","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"MEDICAL_CONDITIONS_NAME","dataIndex":"medicalConditionOther","columnVisibility":"HIDE","sequence":2,"mandatory":false},
{"id":null,"columnName":"MEDICATION","dataIndex":"medicationNameVal","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"MEDICATION_NAME","dataIndex":"medicationOther","columnVisibility":"HIDE","sequence":4,"mandatory":false},
{"id":null,"columnName":"ALLERGIES","dataIndex":"allergiesNameVal","columnVisibility":"SHOW","sequence":5,"mandatory":false},
{"id":null,"columnName":"ALLERGIES_NAME","dataIndex":"allergiesOther","columnVisibility":"HIDE","sequence":6,"mandatory":false},
{"id":null,"columnName":"LEARNING_DIFFICULTIES","dataIndex":"learningDifficultiesNameVal","columnVisibility":"SHOW","sequence":7,"mandatory":false},
{"id":null,"columnName":"LEARNING_DIFFICULTIES_NAME","dataIndex":"learningDifficultiesOther","columnVisibility":"HIDE","sequence":8,"mandatory":false},
{"id":null,"columnName":"UPLOAD_DOCUMENT","dataIndex":"applicantHealthDocument","columnVisibility":"SHOW","sequence":9,"mandatory":false},
{"id":null,"columnName":"UPLOAD_URL","dataIndex":"applicantHealthDocumentUrl","columnVisibility":"SHOW","sequence":10,"mandatory":false}]'
,now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'APPLICANT_HEALTH_INFORMATION' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','APPLICANT_HEALTH_INFORMATION',"Applicant Health Information","Applicant Health Information",
"Aansoeker Gesondheidsinligting","Thông tin sức khỏe của người nộp đơn",now(),1);
END IF;

END $$
CALL V20230817130333__Insert_ApplicantHealthDataGrid() $$
DROP PROCEDURE IF EXISTS V20230817130333__Insert_ApplicantHealthDataGrid $$
DELIMITER ;