DELIMITER $$
DROP PROCEDURE IF EXISTS V20230907195933__Create_student_hostel_application $$
CREATE PROCEDURE V20230907195933__Create_student_hostel_application()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_hostel_application' )) THEN 

CREATE TABLE student_hostel_application (
id bigint NOT NULL AUTO_INCREMENT,
academyLocationId bigint Default NULL,
resourceId bigint Default NULL,
applicationStatus varchar(50) Default NULL,
allocatedHostelId bigint Default NULL,
hostelApplicationSetupId bigint Default NULL,
isReallocateSameHostel boolean default false,
studentId bigint Default NULL,
applicationDate date DEFAULT NULL,
allocatedDate date DEFAULT NULL,
lastUpdatedBy bigint NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (id),
FOREIGN KEY (academyLocationId) REFERENCES academy_location (id),
FOREIGN KEY (resourceId) REFERENCES resources (id),
FOREIGN KEY (allocatedHostelId) REFERENCES hostel_room_allotment (id),
FOREIGN KEY (hostelApplicationSetupId) REFERENCES hostel_application_setup (id),
FOREIGN KEY (studentId) REFERENCES students (userId),
FOREIGN KEY (lastUpdatedBy) REFERENCES users (id));
END IF;  
END $$
CALL V20230907195933__Create_student_hostel_application () $$ 
DROP PROCEDURE IF EXISTS V20230907195933__Create_student_hostel_application $$ 
DELIMITER ;