DELIMITER $$
DROP PROCEDURE IF EXISTS V20230918152507__Create_IntellimaliTransactionEvent $$
CREATE PROCEDURE V20230918152507__Create_IntellimaliTransactionEvent()
BEGIN
 
 IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='INTELLIMALI')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='SCHOLARSHIP');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'INTELLIMALI');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='INTELLIMALI');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'INTELLIMALI_TRANSACTION', 'Intellimali Transaction', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Intellimali Transaction');
 
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'INTELLIMALI_TRANSACTION_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'INTELLIMALI_TRANSACTION_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='INTELLIMALI_TRANSACTION_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'INTELLIMALI_TRANSACTION_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='INTELLIMALI_TRANSACTION_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='INTELLIMALI_TRANSACTION_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='INTELLIMALI_TRANSACTION_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID FROM drop_down T1 WHERE T1.id IN (namedParams)",NULL);
 
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='INTELLIMALI_TRANSACTION_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT
    T1.`id` AS ID,    
    T1.`type` AS FIRST_NAME,
    T1.`type`  AS LAST_NAME,
    T1.`value` AS EMAIL_ID,
    T2.`seqStartId` AS SEQUENCE_NUMBER_FROM,
    T2.`seqEndId` AS SEQUENCE_NUMBER_TO
    FROM
    drop_down T1 
    cross join intelli_mali_report_log T2 
	WHERE
    T1.id IN (namedParams) order by T2.ID desc limit 1",'{
     "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "type",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
		{
            "id": 2,
            "value": "type",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
		 {
            "id": 3,
            "value": "value",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "seqStartId",
            "resultKey": "SEQUENCE_NUMBER_FROM",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "seqEndId",
            "resultKey": "SEQUENCE_NUMBER_TO",
            "displayCode": "",
            "displayOrder": 4
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='INTELLIMALI_TRANSACTION_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T3.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='INTELLIMALI_TRANSACTION');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='INTELLIMALI');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='INTELLIMALI_TRANSACTION_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Intellimali Transaction Email',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Intellimali Transaction Email',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','US Student Payments','<html>
 <head>
 	<title></title>
 </head>
 <body>
 <div style="display: none;">&nbsp;</div>
 
 <table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
 	<tbody>
 		<tr style="background-color:#f0f0f0; line-height:20px;">
 			<td style="padding:20px 20px 20px 20px;">
 			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear INTELLICARD</p>
 			
 			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Attached are the following amounts</p>
 			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Payable to the students of Stellenbosch University</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Student sequence number $recipientData[&quot;SEQUENCE_NUMBER_FROM&quot;] to $recipientData[&quot;SEQUENCE_NUMBER_TO&quot;]</p>
            
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Thanks</p>
 			</td>
 		</tr>	
 	</tbody>
 </table>
 </body>
 </html>');
 

-- End Messaging for Intellimali Transaction Event
END IF;


END $$
CALL V20230918152507__Create_IntellimaliTransactionEvent () $$ 
DROP PROCEDURE IF EXISTS V20230918152507__Create_IntellimaliTransactionEvent $$ 
DELIMITER ;