DELIMITER $$
DROP PROCEDURE IF EXISTS V20231030174247__Create_Notify_BO_RejectForStudentEvnt $$
CREATE PROCEDURE V20231030174247__Create_Notify_BO_RejectForStudentEvnt()
BEGIN

-- START Scholarship Bursary Officer Rejection EVENT 
IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='SCHOLARSHIP_BO_REJECTION_STUDENT')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='SCHOLARSHIP');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'SCHOLARSHIP_BO_REJECTION_STUDENT');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='SCHOLARSHIP_BO_REJECTION_STUDENT');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'SCHOLARSHIP_BO_REJECTION_STUDENT', 'Scholarship Bursary Officer Rejection - Student', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Scholarship Bursary Officer Rejection - Student');
 
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SCHOLARSHIP_BO_REJECTION_STUDENT_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SCHOLARSHIP_BO_REJECTION_STUDENT_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCHOLARSHIP_BO_REJECTION_STUDENT_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'SCHOLARSHIP_BO_REJECTION_STUDENT_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCHOLARSHIP_BO_REJECTION_STUDENT_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SCHOLARSHIP_BO_REJECTION_STUDENT_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCHOLARSHIP_BO_REJECTION_STUDENT_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID FROM scholarship_raise_request T1 WHERE T1.id IN (namedParams)",NULL);
 
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCHOLARSHIP_BO_REJECTION_STUDENT_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT DISTINCT
    T1.id AS ID,
    T3.printName AS STUDENT_PRINT_NAME,
	T3.firstName AS STUDENT_FIRST_NAME,
    T3.middleName AS STUDENT_MIDDLE_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    T2.code AS STUDENT_ID,
    CURDATE() AS CURRENT_DATE_TODAY,
    T3.externalSysRefOne AS STUDENT_EXTERNAL_REFERENCE_NUMBER_1,
    T6.programName AS PROGRAM,
    T5.batchName AS BATCH,
    T19.programPeriodName AS PERIOD,
    T7.seatName AS SEAT_TYPE,
    T8.scholarshipCode AS SCHOLARSHIP_ID,
    T8.scholarshipName AS SCHOLARSHIP_NAME,
    T8.scholarshipCategory AS SCHOLARSHIP_CATEGORY,
    T9.accountingYear AS ACCOUNTING_YEAR,
    T12.displayName AS AL,
    T13.addressText AS CURRENT_ADRESS,
    T14.cityName AS CITY,
    T15.countryName AS COUNTRY,
    T13.pincode AS PIN_CODE,
    T11.firstName AS FIRST_NAME,
	T11.emailId AS EMAIL_ID,
	T11.lastName AS LAST_NAME,
    T11.printName AS PRINT_NAME, 
	T11.printName AS REQUESTOR_NAME,
	T10.lastName AS SCHOLARSHIP_OFFICER_LAST_NAME,
    T10.firstName AS SCHOLARSHIP_OFFICER_FIRST_NAME,
	T10.printName AS SCHOLARSHIP_OFFICER_PRINT_NAME,
    T1.requestStatus AS SCHOLARSHIP_STATUS,
    T1.totalScholarshipAmount AS SCHOLARSHIP_AMOUNT,
    T1.requestDate AS SCHOLARSHIP_REQUEST_DATE,
    T30.followUpRemark AS REMARK_BY_SCHOLARSHIP_OFFICER_MANAGER
FROM
    scholarship_raise_request T1
		LEFT OUTER JOIN
	students T20 ON T1.studentId = T20.userId	
      LEFT OUTER JOIN
	users T2 ON T20.userId = T2.id	
        LEFT OUTER JOIN
    persons T3 ON T20.personId = T3.id
	    LEFT OUTER JOIN
    prog_batch_seat_config T4 ON T1.programBatchSeatConfigId = T4.id
        LEFT OUTER JOIN 
	prog_batch_period_config T19 on T19.programBatchId = T4.programBatchId
       LEFT OUTER JOIN
    batches T5 ON T5.id = T4.programBatchId
       LEFT OUTER JOIN
    programs T6 ON T6.id = T5.programId
       LEFT OUTER JOIN
    seat_types T7 ON T4.seatTypeId = T7.id
	   LEFT OUTER JOIN
    scholarship T8 ON T8.id = T1.scholarshipId
      LEFT OUTER JOIN
	accounting_year T9 ON T9.id=T1.accountingYearId
      LEFT OUTER JOIN
	users T10 ON T10.id=T1.assignedTo
      LEFT OUTER JOIN 
    users T11 ON T11.id=T1.requestBy
    LEFT OUTER JOIN 
    user_academy_locations T21 ON T21.id=T2.id
      LEFT OUTER JOIN 
    academy_location T12 ON T12.id=T21.academyLocationId
      LEFT OUTER JOIN 
    person_addresses T22 ON T22.personId = T3.id
     LEFT OUTER JOIN 
    address T13 ON T22.addressId = T13.id
      LEFT OUTER JOIN
    city T14 on  T14.id=T13.cityId
	  LEFT OUTER JOIN 
    country T15 ON T15.id=T13.countryId
      LEFT OUTER JOIN 
    address_type T16 ON T16.id=T13.addressTypeId AND T16.code='CRNT' AND T16.addressCategory='PERSON'
      LEFT OUTER JOIN 
    staffs T17 ON T17.userId = T10.id
      LEFT OUTER JOIN
    persons T18 ON T18.id = T17.personId
 	LEFT OUTER JOIN
    scholarship_execution_detail T30 ON T1.id = T30.scholarshipRequestId
WHERE
    T1.id IN (namedParams) group by T1.id",'{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		
		{
            "id": 5,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "CURRENT_DATE_TODAY",
            "resultKey": "CURRENT_DATE_TODAY",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "externalSysRefOne",
            "resultKey": "STUDENT_EXTERNAL_REFERENCE_NUMBER_1",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "batchName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "seatName",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "scholarshipCode",
            "resultKey": "SCHOLARSHIP_ID",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "scholarshipName",
            "resultKey": "SCHOLARSHIP_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "scholarshipCategory",
            "resultKey": "SCHOLARSHIP_CATEGORY",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "accountingYear",
            "resultKey": "ACCOUNTING_YEAR",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "displayName",
            "resultKey": "AL",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "addressText",
            "resultKey": "CURRENT_ADRESS",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "cityName",
            "resultKey": "CITY",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "countryName",
            "resultKey": "COUNTRY",
            "displayCode": "",
            "displayOrder": 17
        },
		{
            "id": 19,
            "value": "pincode",
            "resultKey": "PIN_CODE",
            "displayCode": "",
            "displayOrder": 18
        },
		{
            "id": 20,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 19
        },
		{
            "id": 21,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 20
        },
		{
            "id": 22,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 21
        },
		{
            "id": 23,
            "value": "printName",
            "resultKey": "REQUESTOR_NAME",
            "displayCode": "",
            "displayOrder": 22
        },
		{
            "id": 24,
            "value": "requestStatus",
            "resultKey": "SCHOLARSHIP_STATUS",
            "displayCode": "",
            "displayOrder": 23
        },
		{
            "id": 25,
            "value": "totalScholarshipAmount",
            "resultKey": "SCHOLARSHIP_AMOUNT",
            "displayCode": "",
            "displayOrder": 24
        },
		{
            "id": 26,
            "value": "requestDate",
            "resultKey": "SCHOLARSHIP_REQUEST_DATE",
            "displayCode": "",
            "displayOrder": 25
        },
		{
            "id": 27,
            "value": "Remark By Scholarship Officer Manager",
            "resultKey": "REMARK_BY_SCHOLARSHIP_OFFICER_MANAGER",
            "displayCode": "",
            "displayOrder": 26
        },
        {
            "id": 28,
            "value": "programPeriodName",
            "resultKey": "PERIOD",
            "displayCode": "",
            "displayOrder": 27
        },
		 {
            "id": 29,
            "value": "Scholarship Officer Last Name",
            "resultKey": "SCHOLARSHIP_OFFICER_LAST_NAME",
            "displayCode": "",
            "displayOrder": 28
        },
         {
            "id": 30,
            "value": "Scholarship Officer First Name",
            "resultKey": "SCHOLARSHIP_OFFICER_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 29
        },
         {
            "id": 31,
            "value": "Scholarship Officer Print Name",
            "resultKey": "SCHOLARSHIP_OFFICER_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 30
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='SCHOLARSHIP_BO_REJECTION_STUDENT_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='SCHOLARSHIP_BO_REJECTION_STUDENT');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='SCHOLARSHIP_BO_REJECTION_STUDENT');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SCHOLARSHIP_BO_REJECTION_STUDENT_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Scholarship Bursary Officer Rejection',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Scholarship Bursary Officer Rejection',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Scholarship Bursary Officer Rejection','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','Scholarship Bursary Officer Rejection','');
 
-- End Messaging for Scholarship Bursary Officer Rejection Student
END IF;  

END $$
CALL V20231030174247__Create_Notify_BO_RejectForStudentEvnt () $$ 
DROP PROCEDURE IF EXISTS V20231030174247__Create_Notify_BO_RejectForStudentEvnt $$ 
DELIMITER ;