DELIMITER $$
DROP PROCEDURE IF EXISTS V20231107115514__Create_ScholarshipRejectApplicantEvent $$
CREATE PROCEDURE V20231107115514__Create_ScholarshipRejectApplicantEvent()
BEGIN

 IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='SCHOLARSHIP_REJECTED_APPLICANT')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='SCHOLARSHIP');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'SCHOLARSHIP_REJECTED_APPLICANT');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='SCHOLARSHIP_REJECTED_APPLICANT');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'SCHOLARSHIP_REJECTED_APPLICANT', 'Scholarship Rejected - Applicant', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Scholarship Rejected - Applicant');
 
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SCHOLARSHIP_REJECTED_APPLICANT_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SCHOLARSHIP_REJECTED_APPLICANT_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCHOLARSHIP_REJECTED_APPLICANT_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'SCHOLARSHIP_REJECTED_APPLICANT_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCHOLARSHIP_REJECTED_APPLICANT_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SCHOLARSHIP_REJECTED_APPLICANT_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 
 -- Setting the query for the Student distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCHOLARSHIP_REJECTED_APPLICANT_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID FROM scholarship_awardee_list_setup T1 WHERE T1.id IN (namedParams)",NULL);
 
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCHOLARSHIP_REJECTED_APPLICANT_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT DISTINCT
    T1.id AS ID,
    T3.printName AS APPLICANT_PRINT_NAME,
    T3.firstName AS FIRST_NAME,
    T3.middleName AS MIDDLE_NAME,
    T3.lastName AS LAST_NAME,
    T3.emailId AS EMAIL_ID,
    T2.code AS APPLICANT_ID,
    CURDATE() AS CURRENT_DATE_TODAY,
    T3.externalSysRefOne AS APPLICANT_EXTERNAL_REFERENCE_NUMBER_1,
    T4.programName AS PROGRAM,
    T5.batchName AS BATCH,
    T8.scholarshipCode AS SCHOLARSHIP_ID,
    T8.scholarshipName AS SCHOLARSHIP_NAME,
    T8.scholarshipCategory AS SCHOLARSHIP_CATEGORY,
   (CASE
    WHEN T1.scholarshipRaiseRequestId IS NULL THEN T30.amount
    ELSE T40.totalScholarshipAmount
    END) AS SCHOLARSHIP_AMOUNT,
    T11.printName AS SCHOLARSHIP_OWNER_NAME,
    T11.emailId AS SCHOLARSHIP_OWNER_EMAIL,
    T13.displayName AS AL,
    T14.addressText AS CURRENT_ADDRESS,
    T15.cityName AS CITY,
    T16.countryName AS COUNTRY,
    T14.pincode AS PIN_CODE,
    T1.remark AS REJECTION_REASON
FROM
    scholarship_awardee_list_setup T1
    LEFT OUTER JOIN
    application T2 ON T1.applicantId = T2.id
	LEFT OUTER JOIN
    applicant_person T3 ON T2.applicantPersonId = T3.id
    LEFT OUTER JOIN
	batches T5 ON T5.id = T1.batchId
	LEFT OUTER JOIN
    programs T4 ON T4.id = T1.programId
	LEFT OUTER JOIN
    scholarship T8 ON T8.id = T1.scholarshipId
    LEFT OUTER JOIN
    scholarship_raise_request T40 ON T40.id=T1.scholarshipRaiseRequestId
    LEFT OUTER JOIN
    scholarship_nominate_or_award T30 ON T30.id = T1.nominationId
	LEFT OUTER JOIN
    scholarship_owners T10 ON  T10.scholarshipId=T8.id
     LEFT OUTER JOIN
    users T11 ON T10.ownerId=T11.id
      LEFT OUTER JOIN
    academy_location T13 ON T13.id=T2.issuedFromAcademyLocation
      LEFT OUTER JOIN
    applicant_address T14 ON T14.applicantPersonId = T3.id
      LEFT OUTER JOIN
    city T15 on  T15.id=T14.cityId
    LEFT OUTER JOIN
    country T16 ON T16.id=T14.countryId
      LEFT OUTER JOIN
    address_type T17 ON T17.id=T14.addressTypeId AND T17.code='CRNT' AND T17.addressCategory='PERSON'
WHERE
    T1.id IN (namedParams)",'{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "printName",
            "resultKey": "APPLICANT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		
		{
            "id": 5,
            "value": "code",
            "resultKey": "APPLICANT_ID",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "CURRENT_DATE_TODAY",
            "resultKey": "CURRENT_DATE_TODAY",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "externalSysRefOne",
            "resultKey": "APPLICANT_EXTERNAL_REFERENCE_NUMBER_1",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "batchName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "scholarshipCode",
            "resultKey": "SCHOLARSHIP_ID",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "scholarshipName",
            "resultKey": "SCHOLARSHIP_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "scholarshipCategory",
            "resultKey": "SCHOLARSHIP_CATEGORY",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "printName",
            "resultKey": "SCHOLARSHIP_OWNER_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "emailId",
            "resultKey": "SCHOLARSHIP_OWNER_EMAIL",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "displayName",
            "resultKey": "AL",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "addressText",
            "resultKey": "CURRENT_ADDRESS",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "cityName",
            "resultKey": "CITY",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "countryName",
            "resultKey": "COUNTRY",
            "displayCode": "",
            "displayOrder": 17
        },
		{
            "id": 19,
            "value": "pincode",
            "resultKey": "PIN_CODE",
            "displayCode": "",
            "displayOrder": 18
        },
		{
            "id": 20,
            "value": "totalScholarshipAmount",
            "resultKey": "SCHOLARSHIP_AMOUNT",
            "displayCode": "",
            "displayOrder": 19
        },
		{
            "id": 21,
            "value": "remark",
            "resultKey": "REJECTION_REASON",
            "displayCode": "",
            "displayOrder": 20
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='SCHOLARSHIP_REJECTED_APPLICANT_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='SCHOLARSHIP_REJECTED_APPLICANT');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='SCHOLARSHIP_REJECTED_APPLICANT');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SCHOLARSHIP_REJECTED_APPLICANT_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Scholarship Rejected - Applicant',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Scholarship Rejected - Applicant',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Scholarship Rejected - Applicant','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','Scholarship Rejected - Applicant','');
 


END IF;  


END $$
CALL V20231107115514__Create_ScholarshipRejectApplicantEvent () $$ 
DROP PROCEDURE IF EXISTS V20231107115514__Create_ScholarshipRejectApplicantEvent $$ 
DELIMITER ;