DELIMITER $$
DROP PROCEDURE IF EXISTS V20231107154036__Create_HostelOfferLetterAcceptanceEvent $$
CREATE PROCEDURE V20231107154036__Create_HostelOfferLetterAcceptanceEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='HOSTEL_OFFER_LETTER_ACCEPTANCE')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='Hostel');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'HOSTEL_OFFER_LETTER_ACCEPTANCE');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='HOSTEL_OFFER_LETTER_ACCEPTANCE');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'HOSTEL_OFFER_LETTER_ACCEPTANCE', 'Hostel Offer Letter Acceptance', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Hostel Offer Letter Acceptance');
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'HOSTEL_OFFER_LETTER_ACCEPTANCE_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'HOSTEL_OFFER_LETTER_ACCEPTANCE_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_OFFER_LETTER_ACCEPTANCE_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'HOSTEL_OFFER_LETTER_ACCEPTANCE_RECIPIENT');
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_OFFER_LETTER_ACCEPTANCE_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='HOSTEL_OFFER_LETTER_ACCEPTANCE_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_OFFER_LETTER_ACCEPTANCE_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID,T1.academyLocationId AS ACADEMY_LOCATION_IDS FROM applicant_hostel_requirement T1 WHERE T1.id IN (namedParams)",NULL);
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_OFFER_LETTER_ACCEPTANCE_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT DISTINCT
    T1.id AS ID,
    T6.code AS APPLICATION_ID,
    T5.firstName AS FIRST_NAME,
	T5.lastName AS LAST_NAME,
	T5.emailId AS EMAIL_ID,
    T5.firstName AS APP_FIRST_NAME,
    T5.middleName AS APP_MIDDLE_NAME,
    T5.lastName AS APP_LAST_NAME,
    T4.salutationName AS APPLICANT_INITIALS,
    T7.logoUrl AS LOGO_URL,
    T3.itemCode AS ACADEMIC_TERM,
    T9.locationName AS OFFERED_LOCATION,
	'APPLICANT' AS USER_TYPE_KEY,
     ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T7.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T7.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
FROM
    applicant_hostel_requirement T1
		LEFT OUTER JOIN 
    hostel_application_setup T2 ON T1.waitingListTypeSetupId=T2.id
		LEFT OUTER JOIN
	academic_term T3 ON T2.year = T3.id   
        LEFT OUTER JOIN
    applicant_person T5 ON T1.applicantPersonId = T5.id
        LEFT OUTER JOIN 
    salutations T4 ON T5.salutationId = T4.id    
        LEFT OUTER JOIN
    application T6 ON T6.applicantPersonId = T5.id
        LEFT OUTER JOIN
    academy_location T7 ON T7.id = T1.academyLocationId
        LEFT OUTER JOIN
    hostel_offer_detail T8  ON T8.applicantHostelRequirementId = T1.id
        LEFT OUTER JOIN
    locations T9 ON T9.id=T8.locationId
        LEFT OUTER JOIN
	multi_language ml on ml.id=T5.correspondence_language
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams)",'{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "APP_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "APP_LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "APP_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		
		{
            "id": 5,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "salutationName",
            "resultKey": "APPLICANT_INITIALS",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "itemCode",
            "resultKey": "ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "locationName",
            "resultKey": "OFFERED_LOCATION",
            "displayCode": "",
            "displayOrder": 9
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='HOSTEL_OFFER_LETTER_ACCEPTANCE_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='HOSTEL_OFFER_LETTER_ACCEPTANCE');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='HOSTEL_OFFER_LETTER_ACCEPTANCE');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='HOSTEL_OFFER_LETTER_ACCEPTANCE_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Hostel Offer Letter Acceptance',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Hostel Offer Letter Acceptance',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Hostel Offer Letter Acceptance','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Hostel Offer Letter Acceptance','');

END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_OFFER_LETTER_ACCEPTANCE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_OFFER_LETTER_ACCEPTANCE', 'Hostel Offer Letter Acceptance', 'Hostel Offer Letter Acceptance', 'Koshuisaanbieding Briefaanvaarding', 'Chấp nhận thư mời ký túc xá',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_OFFER_LETTER_ACCEPTANCE_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_OFFER_LETTER_ACCEPTANCE_DL', 'Hostel Offer Letter Acceptance DL', 'Hostel Offer Letter Acceptance DL', 'Koshuisaanbod Briefaanvaarding DL', 'Thư chấp nhận thư mời ký túc xá DL',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_OFFER_LETTER_ACCEPTANCE_RECIPIENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_OFFER_LETTER_ACCEPTANCE_RECIPIENT', 'Hostel Offer Letter Acceptance Recipient', 'Hostel Offer Letter Acceptance Recipient', 'Koshuisaanbod Brief Aanvaarding Ontvanger', 'Người nhận thư chấp nhận thư mời ký túc xá',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='HOSTEL_OFFER_LETTER_ACCEPTANCE')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('HOSTEL_OFFER_LETTER_ACCEPTANCE', 'Hostel Offer Letter Acceptance');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='HOSTEL_OFFER_LETTER_ACCEPTANCE_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('HOSTEL_OFFER_LETTER_ACCEPTANCE_DL', 'Hostel Offer Letter Acceptance DL');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='HOSTEL_OFFER_LETTER_ACCEPTANCE_RECIPIENT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('HOSTEL_OFFER_LETTER_ACCEPTANCE_RECIPIENT', 'Hostel Offer Letter Acceptance Recipient');
END IF; 

END $$
CALL V20231107154036__Create_HostelOfferLetterAcceptanceEvent () $$ 
DROP PROCEDURE IF EXISTS V20231107154036__Create_HostelOfferLetterAcceptanceEvent $$ 
DELIMITER ;










