DELIMITER $$
DROP PROCEDURE IF EXISTS V20231227153911__Create_zohoLeadApplicant $$
CREATE PROCEDURE V20231227153911__Create_zohoLeadApplicant()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='zoho_lead_applicant_admission')) THEN 
CREATE TABLE zoho_lead_applicant_admission (
    id bigint NOT NULL AUTO_INCREMENT,
	leadId bigint NOT NULL,
    applicationId bigint NOT NULL,
    admissionId bigint NOT NULL,
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_zoho_lead_ap_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_zoho_lead_ap_leadId_idx (leadId),
  KEY fk_zoho_lead_ap_applicationId_idx (applicationId),
  KEY fk_zoho_lead_ap_admissionId_idx (admissionId),
  CONSTRAINT fk_zoho_lead_ap_leadId FOREIGN KEY (leadId) REFERENCES zoho_lead (id),
  CONSTRAINT fk_zoho_lead_ap_applicationId FOREIGN KEY (applicationId) REFERENCES application (id),
  CONSTRAINT fk_zoho_lead_ap_admissionId FOREIGN KEY (admissionId) REFERENCES admission (id)

) ENGINE=InnoDB;
END IF; 

END $$
CALL V20231227153911__Create_zohoLeadApplicant () $$ 
DROP PROCEDURE IF EXISTS V20231227153911__Create_zohoLeadApplicant $$ 
DELIMITER ;