DELIMITER $$
DROP PROCEDURE IF EXISTS V20240202133516__Create_FreeFormServiceReqApprovalEvent $$
CREATE PROCEDURE V20240202133516__Create_FreeFormServiceReqApprovalEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='FREE_FORM_SERVICE_REQUEST_APPROVAL')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='SERVICE_REQUEST');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'FREE_FORM_SERVICE_REQUEST_APPROVAL');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='FREE_FORM_SERVICE_REQUEST_APPROVAL');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'FREE_FORM_SERVICE_REQUEST_APPROVAL', 'Free Form service Request - Approval', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Free Form service Request - Approval');
 
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'FREE_FORM_SERVICE_REQUEST_APPROVAL_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'FREE_FORM_SERVICE_REQUEST_APPROVAL_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FREE_FORM_SERVICE_REQUEST_APPROVAL_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'FREE_FORM_SERVICE_REQUEST_APPROVAL_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FREE_FORM_SERVICE_REQUEST_APPROVAL_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='FREE_FORM_SERVICE_REQUEST_APPROVAL_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 
 -- Setting the query for the Student distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FREE_FORM_SERVICE_REQUEST_APPROVAL_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID FROM execution_details T1 WHERE T1.id IN (namedParams)",NULL);
 
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FREE_FORM_SERVICE_REQUEST_APPROVAL_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT 
    DISTINCT
    T1.id AS ID,
    T6.firstName AS FIRST_NAME,
    T6.lastName AS LAST_NAME,
    T6.emailId AS EMAIL_ID,
    T6.printName AS REQUESTOR_NAME,
    T6.code AS REQUESTOR_ID,
    T4.itemValue AS FREE_FORM_REQUEST_CATEGORIES,
    T5.status AS CLOSURE_REASON,
    T7.code AS APPROVER_ID,
    T7.printName AS APPROVER_NAME
FROM
    execution_details AS T1
        LEFT OUTER JOIN
    service_requests AS T2 ON T1.serviceRequestId = T2.id
        LEFT OUTER JOIN
    free_form_request_details AS T3 ON T1.serviceRequestId = T3.serviceRequestId
        LEFT OUTER JOIN
    free_form_request_categories AS T4 ON T3.freeFormRequestCategoryId = T4.id
        LEFT OUTER JOIN
    closure_reason AS T5 ON T1.closureReasonId = T5.id
        LEFT OUTER JOIN
    users AS T6 ON T2.requester = T6.id
        LEFT OUTER JOIN
    users AS T7 ON T1.userId = T7.id
WHERE
T1.id IN (namedParams) ",'{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "requestorName",
            "resultKey": "REQUESTOR_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "requestorId",
            "resultKey": "REQUESTOR_ID",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "freeFormRequestCategory",
            "resultKey": "FREE_FORM_REQUEST_CATEGORIES",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "closureReason",
            "resultKey": "CLOSURE_REASON",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "approverId",
            "resultKey": "APPROVER_ID",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "approverName",
            "resultKey": "APPROVER_NAME",
            "displayCode": "",
            "displayOrder": 5
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='FREE_FORM_SERVICE_REQUEST_APPROVAL_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='FREE_FORM_SERVICE_REQUEST_APPROVAL');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='FREE_FORM_SERVICE_REQUEST_APPROVAL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='FREE_FORM_SERVICE_REQUEST_APPROVAL_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='GeneralMessage');
 
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Free Form service Request - Approval',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Free Form service Request - Approval',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Free Form service Request - Approval','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','Free Form service Request - Approval','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+4,@msgtemplateconfigId+1,'6','Free Form service Request - Approval','');
 
 END IF;  


END $$
CALL V20240202133516__Create_FreeFormServiceReqApprovalEvent () $$ 
DROP PROCEDURE IF EXISTS V20240202133516__Create_FreeFormServiceReqApprovalEvent $$ 
DELIMITER ;