DELIMITER $$
DROP PROCEDURE IF EXISTS V20240315130000__Create_prog_batch_period_courses $$
CREATE PROCEDURE V20240315130000__Create_prog_batch_period_courses()
BEGIN

IF EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='prog_batch_period_courses') THEN 
drop view prog_batch_period_courses;
END IF; 

create view prog_batch_period_courses as 
select p.academyLocationId as academy_location_id, 
p.id as prog_id, p.programCode as prog_code, p.programName as prog_name, p.lastUpdate as prog_lastupdate,mprog.moodleId as prog_moodleid, mprog.parentMoodleId as prog_parent_moodleid,
b.id as batch_id, b.batchName as batch_name, b.lastUpdate as batch_lastupdate,mb.moodleId as batch_moodleid, mprog.moodleId as batch_parent_moodleid,
period.id as period_id, period.programPeriodName as period_name, period.lastUpdate as period_lastupdate,  mperiod.moodleId as period_moodleid, mb.moodleId as period_parent_moodleid,
c.id as course_id, c.courseCode as course_code ,c.courseName as course_name, c.lastUpdate as course_lastupdate,mc.moodleId as course_moodleid, mperiod.moodleId as course_parent_moodleid,
cv.id as course_variant_id, param.sectionid as section_id, cv.courseVariantCode as course_variant_name, cv.lastUpdate as course_variant_lastupdate, mcv.moodleCourseId as course_variant_moodleid, mc.moodleId as course_variant_parent_moodleid 
from program_batch_course_param param
join batches b on param.programBatchId=b.id
join prog_batch_period_config period on param.progBatchPeriodConfigId = period.id and period.programBatchId = b.id
join programs p on b.programId = p.id
join courses c on param.courseId = c.id
join course_variants cv on param.courseVarientId = cv.id and cv.courseid=c.id and p.academyLocationId =  cv.academyLocationId 
left join moodle_transaction_info mprog on mprog.academiaId = p.id and mprog.moodleTransactionType='PROGRAM' and mprog.hierarchy = 'PROG_BATCH_PERIOD_COURSE_VARIANT'
left join moodle_transaction_info mb on mb.academiaId = b.id and mb.parentAcademiaId = p.id and mprog.hierarchy = mb.hierarchy and mb.moodleTransactionType='BATCH'
left join moodle_transaction_info mperiod on mperiod.academiaId = period.id and mperiod.parentAcademiaId = b.id and mb.hierarchy = mperiod.hierarchy and mperiod.moodleTransactionType='PERIOD'
left join moodle_transaction_info mc on mc.academiaId = c.id and mc.parentAcademiaId = period.id  and mperiod.hierarchy = mc.hierarchy and mc.moodleTransactionType='COURSE'
left join moodle_course mcv on mcv.academiaCourseVariantId = cv.id and mcv.sectionId=param.sectionId and mcv.parentAcademiaId = c.id and mcv.academyLocationId = p.academyLocationId and mc.hierarchy = mcv.hierarchy;

END $$
CALL V20240315130000__Create_prog_batch_period_courses () $$ 
DROP PROCEDURE IF EXISTS V20240315130000__Create_prog_batch_period_courses $$ 
DELIMITER ;