DELIMITER $$
DROP PROCEDURE IF EXISTS V20240319160214__Alter_QuestionPaperBank $$
CREATE PROCEDURE V20240319160214__Alter_QuestionPaperBank()
BEGIN

IF EXISTS ((select column_name from INFORMATION_SCHEMA.columns where table_schema=DATABASE() and table_name = 'question_paper_bank' and column_name in ('programId','batchId','periodId'))) THEN 
ALTER TABLE `question_paper_bank`
DROP FOREIGN KEY `question_paper_bank_batch_fk`,
DROP FOREIGN KEY `question_paper_bank_period_fk`,
DROP FOREIGN KEY `question_paper_bank_program_fk`;

-- Modify columns to allow NULL values
ALTER TABLE `question_paper_bank`
MODIFY COLUMN `programId` BIGINT NULL DEFAULT NULL,
MODIFY COLUMN `batchId` BIGINT NULL DEFAULT NULL,
MODIFY COLUMN `periodId` BIGINT NULL DEFAULT NULL;

-- Add new foreign key constraints
ALTER TABLE `question_paper_bank`
ADD CONSTRAINT `question_paper_bank_batch_fk` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
ADD CONSTRAINT `question_paper_bank_period_fk` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
ADD CONSTRAINT `question_paper_bank_program_fk` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`);

END IF; 

IF NOT EXISTS ((select column_name from INFORMATION_SCHEMA.columns where table_schema=DATABASE() and table_name = 'question_paper_bank' and column_name = 'durationInMins')) THEN 
ALTER TABLE `question_paper_bank`
ADD COLUMN durationInMins varchar(255) default null;
END IF; 


END $$
CALL V20240319160214__Alter_QuestionPaperBank() $$
DROP PROCEDURE IF EXISTS V20240319160214__Alter_QuestionPaperBank $$
DELIMITER ;