DELIMITER $$
DROP PROCEDURE IF EXISTS V20240320180911__Create_multipleReasonsRequired $$
CREATE PROCEDURE V20240320180911__Create_multipleReasonsRequired()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='multipleReason')) THEN 
CREATE TABLE `multipleReason` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `code` BIT(1) NOT NULL DEFAULT b'0',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_multipleReason_updateby` (`lastUpdatedBy`),
  CONSTRAINT `fk_multipleReason_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'multipleReason','MULTIPLE_REASON_REQUIRED','General','COMMON_MASTER',0,0,NULL,1,SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'MULTIPLE_REASON', @standardMasterMaxId+1, 'Boolean', '1', 0, 0, 0, 0, '1', SYSDATE());


insert into multipleReason (`code`,`lastUpdate`,`lastUpdatedBy`) values(false,SYSDATE(),1);

END IF; 

END $$
CALL V20240320180911__Create_multipleReasonsRequired () $$ 
DROP PROCEDURE IF EXISTS V20240320180911__Create_multipleReasonsRequired $$ 
DELIMITER ;