DELIMITER $$
DROP PROCEDURE IF EXISTS V20240320190317__Alter_cost_center_poet_detail_For_Poet $$
CREATE PROCEDURE V20240320190317__Alter_cost_center_poet_detail_For_Poet()
BEGIN
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='cost_center_poet_detail' AND column_name='projectNumberId')) THEN 
ALTER TABLE cost_center_poet_detail ADD COLUMN projectNumberId bigint(25) NULL DEFAULT NULL after costCentreTransactionId,
 Add Foreign key (projectNumberId) REFERENCES  poet_master_details (id) ;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='cost_center_poet_detail' AND column_name='taskNumberId')) THEN 
ALTER TABLE cost_center_poet_detail ADD COLUMN taskNumberId bigint(25) NULL DEFAULT NULL after projectNumberId,
 Add Foreign key (taskNumberId) REFERENCES  poet_master_task_details (id) ;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='cost_center_poet_detail' AND column_name='contractDetailId')) THEN 
ALTER TABLE cost_center_poet_detail ADD COLUMN contractDetailId bigint(25) NULL DEFAULT NULL after taskNumberId,
 Add Foreign key (contractDetailId) REFERENCES  poet_master_contract_details (id) ;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='cost_center_poet_detail' AND column_name='fundingSourceId')) THEN 
ALTER TABLE cost_center_poet_detail ADD COLUMN fundingSourceId bigint(25) NULL DEFAULT NULL after contractDetailId,
 Add Foreign key (fundingSourceId) REFERENCES  poet_master_contract_fund_source (id) ;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='cost_center_poet_detail' AND column_name='expenditureTypeId')) THEN 
ALTER TABLE cost_center_poet_detail ADD COLUMN expenditureTypeId bigint(25) NULL DEFAULT NULL after fundingSourceId,
Add Foreign key (expenditureTypeId) REFERENCES  expenditure_type_csm (id) ;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='cost_center_poet_detail' AND column_name='expenditureOrganizationId')) THEN 
ALTER TABLE cost_center_poet_detail ADD COLUMN expenditureOrganizationId bigint(25) NULL DEFAULT NULL after expenditureTypeId,
 Add Foreign key (expenditureOrganizationId) REFERENCES  expenditure_organization_csm (id) ;
END IF; 

END $$
CALL V20240320190317__Alter_cost_center_poet_detail_For_Poet() $$
DROP PROCEDURE IF EXISTS V20240320190317__Alter_cost_center_poet_detail_For_Poet $$
DELIMITER ;