DELIMITER $$
DROP PROCEDURE IF EXISTS V20240419162315__Insert_OUMStatementOfAccount_Sponsor $$
CREATE PROCEDURE V20240419162315__Insert_OUMStatementOfAccount_Sponsor()
BEGIN

IF NOT EXISTS ((SELECT * FROM report_template WHERE templateCode = 'OUM_STATEMENT_OF_ACCOUNT_SPONSOR')) THEN 
INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '29', 'OUM_STATEMENT_OF_ACCOUNT_SPONSOR', 'OUM Statement of Account - Sponsor', 'OUM_STATEMENT_OF_ACCOUNT_SPONSOR.png','CommonReportOUM_SOA_Sponsor.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', "OUM_StatementofAccount_Sponsor.jasper", 'AcademiaLogo.png');
END IF;

set @OUM_STATEMENT_OF_ACCOUNT_SPONSOR = (select max(id) from report_template where templateCode ='OUM_STATEMENT_OF_ACCOUNT_SPONSOR');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_SOA')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_SOA', 'Statement of Account', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_SPONSOR_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_SPONSOR_NAME', 'Sponsor Name', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_SPONSOR_NUMBER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_SPONSOR_NUMBER', 'Sponsor Number', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_STATEMENT_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_STATEMENT_DATE', 'Statement Date', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_PERIOD')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_PERIOD', 'Period', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_DATE', 'Date', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_REFERENCE_NUMBER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_REFERENCE_NUMBER', 'Reference Number', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_DESCRIPTION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_DESCRIPTION', 'Description', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_DR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_DR', 'Dr', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_CR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_CR', 'Cr', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_BALANCE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_BALANCE', 'Balance', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT_SPONSOR and keyValue='TRANS_FOOTER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT_SPONSOR, 'TRANS_FOOTER', 'This is a computer-generated document and requires no authentication. If you have any queries,contact us by email at feesfinance@open.ac.mu', '1', NOW());
END IF;

END $$
CALL V20240419162315__Insert_OUMStatementOfAccount_Sponsor() $$
DROP PROCEDURE IF EXISTS V20240419162315__Insert_OUMStatementOfAccount_Sponsor $$
DELIMITER ;