DELIMITER $$
DROP PROCEDURE IF EXISTS V20240424123123__Update_hostelOfferLetterExpireEvent $$
CREATE PROCEDURE V20240424123123__Update_hostelOfferLetterExpireEvent()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS (select MAX(id) from dtprovider where dataProviderName="HOSTEL_OFFER_LETTER_EXPIRED_RECIPIENT") THEN 

SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="HOSTEL_OFFER_LETTER_EXPIRED_RECIPIENT");

update sql_dtprovider set sqlQuery="SELECT DISTINCT
    T1.id AS ID,
    T6.code AS APPLICATION_ID,
    T5.firstName AS FIRST_NAME,
	T5.lastName AS LAST_NAME,
	T5.emailId AS EMAIL_ID,
    T5.firstName AS APP_FIRST_NAME,
    T5.middleName AS APP_MIDDLE_NAME,
    T5.lastName AS APP_LAST_NAME,
    T5.initials AS APPLICANT_INITIALS,
	T4.salutationName AS HOSTEL_SALUTATION,
    T7.logoUrl AS LOGO_URL,
    T3.itemCode AS ACADEMIC_TERM,
    T9.locationName AS OFFERED_LOCATION,
    T8.offerLetterExpiryDate AS OFFER_EXPIRY_DATE,
    T5.printName AS APP_PRINT_NAME,
    T5.externalSysRefOne AS HOSTEL_EXTERNAL_REFERENCE_NUMBER_ONE,
	'APPLICANT' AS USER_TYPE_KEY,
     ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T7.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T7.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
FROM
    applicant_hostel_requirement T1
		LEFT OUTER JOIN 
    hostel_application_setup T2 ON T1.waitingListTypeSetupId=T2.id
		LEFT OUTER JOIN
	academic_term T3 ON T2.year = T3.id   
        LEFT OUTER JOIN
    applicant_person T5 ON T1.applicantPersonId = T5.id
        LEFT OUTER JOIN 
    salutations T4 ON T5.salutationId = T4.id    
        LEFT OUTER JOIN
    application T6 ON T6.applicantPersonId = T5.id
        LEFT OUTER JOIN
    academy_location T7 ON T7.id = T1.academyLocationId
	   LEFT OUTER JOIN
    hostel_offer_detail T8  ON T8.applicantHostelRequirementId = T1.id
       LEFT OUTER JOIN
    locations T9 ON T9.id=T8.locationId
       LEFT OUTER JOIN
	multi_language ml on ml.id=T5.correspondence_language
       LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams)", jsonString='{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "APP_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "APP_LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "APP_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		
		{
            "id": 5,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "initials",
            "resultKey": "APPLICANT_INITIALS",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "itemCode",
            "resultKey": "ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "locationName",
            "resultKey": "OFFERED_LOCATION",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "offerLetterExpiryDate",
            "resultKey": "OFFER_EXPIRY_DATE",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "printName",
            "resultKey": "APP_PRINT_NAME",
            "displayCode": "",
            "displayOrder":11
        },
		{
            "id": 13,
            "value": "externalSysRefOne",
            "resultKey": "HOSTEL_EXTERNAL_REFERENCE_NUMBER_ONE",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "salutationName",
            "resultKey": "HOSTEL_SALUTATION",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
 }' where dataProviderId=@dtProviderId;

END IF; 

SET SQL_SAFE_UPDATES=1;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='OFFER_EXPIRY_DATE' AND objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','OFFER_EXPIRY_DATE','Offer Expire Date','Offer Expire Date',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='APP_PRINT_NAME' AND objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','APP_PRINT_NAME','Applicant Print Name','Applicant Print Name',now(),1);
END IF;

END $$
CALL V20240424123123__Update_hostelOfferLetterExpireEvent () $$
DROP PROCEDURE IF EXISTS V20240424123123__Update_hostelOfferLetterExpireEvent $$
DELIMITER ;