DELIMITER $$
DROP PROCEDURE IF EXISTS V20240429064731__Create_allowed_scholarship $$
CREATE PROCEDURE V20240429064731__Create_allowed_scholarship()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='allowedScholarshipId')) THEN 
alter table scholarship drop foreign key scholarship_ibfk_2;
alter table scholarship drop column allowedScholarshipId;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='allowed_scholarship')) THEN 
CREATE TABLE allowed_scholarship (
id bigint(20) NOT NULL AUTO_INCREMENT,
allowedscholarshipId bigint(20),
parentScholarshipId bigint(20),
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
PRIMARY KEY (id),
FOREIGN KEY (allowedscholarshipId) REFERENCES scholarship (id),
FOREIGN KEY (parentScholarshipId) REFERENCES scholarship (id));
END IF; 
END $$
CALL V20240429064731__Create_allowed_scholarship () $$ 
DROP PROCEDURE IF EXISTS V20240429064731__Create_allowed_scholarship $$ 
DELIMITER ;