DELIMITER $$
DROP PROCEDURE IF EXISTS V20240517173124__Update_HOSTEL_ALLOCATION_STUDENT_EVENT $$
CREATE PROCEDURE V20240517173124__Update_HOSTEL_ALLOCATION_STUDENT_EVENT()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_ALLOCATION_STUDENT_RECIPIENT')) THEN 
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_ALLOCATION_STUDENT_RECIPIENT');
UPDATE sql_dtprovider
SET sqlQuery = "SELECT DISTINCT
     
    T1.id AS ID,
    T8.itemCode AS ALLOCATION_YEAR,
    T4.code AS STUDENT_ID,
    T5.printName AS PRINT_NAME,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.emailId AS EMAIL_ID,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T5.externalSysRefOne AS EXTERNAL_REFERENCE_NUMBER_1,
    T11.locationName AS HOSTEL_LOCATION,
    T9.salutationName AS TITLE,
    T5.initials AS INITIALS,
    T2.code AS HOSTEL_CODE,
    T2.resourceName AS HOSTEL_NAME,
    T7.logoUrl AS LOGO_URL,
    T12.printName AS ALLOCATED_BY,
    ml.code AS LANGUAGE_KEY,
    T1.allocatedDate AS DATE,
    (CASE
        WHEN
            T7.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T7.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
FROM
    student_hostel_application T1
        LEFT OUTER JOIN
    resources T2 ON T1.allocatedHostelId = T2.id
        LEFT OUTER JOIN
	resource_academy_locations T10 ON T10.resourceId = T2.id  and T10.whetherPrimary = 1
        LEFT OUTER JOIN
	academy_location T11 ON T11.id = T10.academyLocationId
        LEFT OUTER JOIN
    students T3 ON T1.studentId = T3.userId
        LEFT OUTER JOIN
    users T4 ON T4.id = T3.userId
        LEFT OUTER JOIN
    persons T5 ON T3.personId = T5.id
        LEFT OUTER JOIN
    academy_location T7 ON T7.id = T1.academyLocationId
        LEFT OUTER JOIN
    academic_term T8 ON T8.id = T1.allocationYearId
        LEFT OUTER JOIN
    multi_language ml ON ml.id = T5.correspondence_language
        LEFT OUTER JOIN
    salutations T9 ON T5.salutationId = T9.id
        LEFT OUTER JOIN
	users T12 ON T12.id = T1.allocatedById    
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams) ",
    jsonString = '{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		
		{
            "id": 5,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "code",
            "resultKey": "HOSTEL_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "resourceName",
            "resultKey": "HOSTEL_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemCode",
            "resultKey": "ALLOCATION_YEAR",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "externalSysRefOne",
            "resultKey": "EXTERNAL_REFERENCE_NUMBER_1",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "title",
            "resultKey": "TITLE",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "initials",
            "resultKey": "INITIALS",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "locationName",
            "resultKey": "HOSTEL_LOCATION",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "allocatedBy",
            "resultKey": "ALLOCATED_BY",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "date",
            "resultKey": "DATE",
            "displayCode": "",
            "displayOrder": 16
        }
    ]
 }'
    where dataProviderId = @dtproviderId;
    
    SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 IF EXISTS (select id from msg_template_config where code = "Hostel Allocation Student" limit 1) THEN
    
	   SET @msgtemplateconfigId=(select id from msg_template_config where code = "Hostel Allocation Student" limit 1);
       INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
       VALUES (@msgtemplateId+1,@msgtemplateconfigId,'2','Hostel Allocation Student','');
 
       INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
       VALUES (@msgtemplateId+2,@msgtemplateconfigId,'6','Hostel Allocation Student','');
    
 END IF; 
 
    
    
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240517173124__Update_HOSTEL_ALLOCATION_STUDENT_EVENT () $$
DROP PROCEDURE IF EXISTS V20240517173124__Update_HOSTEL_ALLOCATION_STUDENT_EVENT $$
DELIMITER ;