DELIMITER $$
DROP PROCEDURE IF EXISTS V20240605140544__Update_salesForceApplicantPeriodId $$
CREATE PROCEDURE V20240605140544__Update_salesForceApplicantPeriodId()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND  table_name='salesforce_applicant_program' AND column_name='periodId')) THEN 
update salesforce_applicant_program sap join application a on a.id=sap.applicationId
 join application_program ap on ap.applicationId=a.id 
 join prog_batch_seat_config pbsc on pbsc.id=ap.progBatchSeatConfigId
 join batches b on b.id=pbsc.programBatchId
 join prog_batch_period_config pbpc on pbpc.programBatchId=b.id and pbpc.isCurrentPeriodOfProgram=true
 set sap.periodId=pbpc.id
 where sap.periodId is null;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240605140544__Update_salesForceApplicantPeriodId () $$
DROP PROCEDURE IF EXISTS V20240605140544__Update_salesForceApplicantPeriodId $$
DELIMITER ;