DELIMITER $$
DROP PROCEDURE IF EXISTS V20240610164122__Create_GEDUTranscriptTemplate $$
CREATE PROCEDURE V20240610164122__Create_GEDUTranscriptTemplate()
BEGIN

set @gedu = (select max(id) from report_type where typeName='Mark Sheet' );
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'GEDU_TRANSCRIPT_TEMPLATE')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`,`documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@gedu, 'GEDU_TRANSCRIPT_TEMPLATE', 'GEDU Transcript Template', 'GEDU_TRANSCRIPT_TEMPLATE.png', 'CommonReport_GEDU_TRANSCRIPT_TEMPLATE.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'GEDU_TRANSCRIPT_TEMPLATE.jasper', 'AcademiaLogo.png');
END IF; 


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'GEDU_TRANSCRIPT_TEMPLATE')) THEN 
set @H1 = (select max(id)  from report_template where templateCode ='GEDU_TRANSCRIPT_TEMPLATE');
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_STUDENT_NAME', 'Student Name:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_STUDENT_ID', 'Student ID No.:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_QUALIFICATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_QUALIFICATION', 'Qualification:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_PROGRAM_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_PROGRAM_CODE', 'Program Code:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_PROGRAM_TITLE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_PROGRAM_TITLE', 'Program Title:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_DATE_ISSUED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_DATE_ISSUED', 'Date Issued:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_OF_BIRTH')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_OF_BIRTH', 'Date of Birth:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_CENTRE_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_CENTRE_NO', 'Centre No.:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_REGISTRATION_NUMBER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_REGISTRATION_NUMBER', 'Registration Number(Awardy Body):', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_PROVISIONAL_GRADES_OF')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_PROVISIONAL_GRADES_OF', 'Provisional grades of completed units for the above-mentioned program are indicated below:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_ACAD_TRANS_REC')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_ACAD_TRANS_REC', 'ACADEMICS TRANSCRIPT OF RECORDS', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_UNITE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_UNITE_CODE', 'Unite Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_UNITE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_UNITE_NAME', 'Unit Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_LEVEL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_LEVEL', 'Level', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_CREDIT_GHL_VALUE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_CREDIT_GHL_VALUE', 'Credit/GLH Value', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_CREDIT_GHL_EARNED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_CREDIT_GHL_EARNED', 'Credit/GLH Value Earned', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_GRADE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_GRADE', 'Grade', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_UNIT_TRANSFREED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_UNIT_TRANSFREED', 'Units Transfreed', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_TOC_GHL_VALUE_EARNED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_TOC_GHL_VALUE_EARNED', 'Total TOC Credit/GHL Value Earned:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_TOTAL_GHL_REQ')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_TOTAL_GHL_REQ', 'Total Credit/GLH Value Required:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_TOTAL_GHL_ATTEN')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_TOTAL_GHL_ATTEN', 'Total Credit/GLH Value Attended:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_TOTAL_GHL_EARNED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_TOTAL_GHL_EARNED', 'Total Credit/GLH Value Earned:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_LAST_SEM_ATTND')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_LAST_SEM_ATTND', 'Last Semester attended:', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_DESCRIPTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_DESCRIPTION', 'Please note that grade decisions are provisional. They are only confirmed once internal and external moderation has taken place and grading decisions have been agreed upon by the assessment board.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_DESCRIPTION1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_DESCRIPTION1', 'This is a temporary transcript issued upon the students request. The final grades are subject to the approval of the awarding body, once the program qualification has been completed.', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_END_OF_TRANS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_END_OF_TRANS', 'END OF TRANSCRIPT', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_CENTER_HEAD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_CENTER_HEAD', 'Center Head', '1', now());
END IF;

END $$
CALL V20240610164122__Create_GEDUTranscriptTemplate () $$ 
DROP PROCEDURE IF EXISTS V20240610164122__Create_GEDUTranscriptTemplate $$ 
DELIMITER ;