DELIMITER $$
DROP PROCEDURE IF EXISTS V20240612144421__Create_CourseRegistrationConfirmationEvent $$
CREATE PROCEDURE V20240612144421__Create_CourseRegistrationConfirmationEvent()
BEGIN

 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='PROGRAM_AND_COURSE');
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'COURSE_REGISTRATION_CONFIRMATION_PORTALS');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='COURSE_REGISTRATION_CONFIRMATION_PORTALS');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`,`uiDisplayCode`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'COURSE_REGISTRATION_CONFIRMATION_PORTALS', 'Course Registration Confirmation Portals', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Course Registration Confirmation Portals', 'Course Registration Confirmation Portals');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- DL data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'COURSE_REGISTRATION_CONFIRMATION_PORTALS_DL', 'SQL');

-- Recipient Infor data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'COURSE_REGISTRATION_CONFIRMATION_PORTALS_RCPNT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='COURSE_REGISTRATION_CONFIRMATION_PORTALS_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`,`idParamName`) VALUES (@msgRecipientId+1, @dtproviderId, 'COURSE_REGISTRATION_CONFIRMATION_PORTALS_RCPNT','CONTEXT_RECORD_ID');


-- The under sql code gives for the user distribution list ,this information can be fetched
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='COURSE_REGISTRATION_CONFIRMATION_PORTALS_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='COURSE_REGISTRATION_CONFIRMATION_PORTALS_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the Parent distribution list
SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='COURSE_REGISTRATION_CONFIRMATION_PORTALS_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT DISTINCT
   T2.id AS USER_ID
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null
AND T2.id in(namedParams)",NULL); 

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='COURSE_REGISTRATION_CONFIRMATION_PORTALS_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT DISTINCT
    T2.id AS ID,
    T18.firstName AS FIRST_NAME,
    T18.lastName AS LAST_NAME,
	T7.displayName AS ACADEMY_LOCATION,
	T7.academyName AS ACADEMY_NAME,
    T7.locationName AS LOCATION_NAME,
	T5.programNameToBePrint AS PROGRAM_NAME,
    T4.printName AS INTAKE_NAME,
    T6.printName AS PERIOD_NAME,
    T17.code AS STUDENT_ID,
    T17.printName as STUDENT_NAME,
    T2.code AS ADMISSION_ID,
    T18.emailId AS EMAIL_ID,
    T18.alternateEmailId as SECONDARY_EMAIL_ID,
    T18.mobileNumber AS MOBILE_NO,
    T18.mobileCountryCode AS MOBILE_CODE,
    GROUP_CONCAT(DISTINCT T20.courseVariantCode) AS COURSE_VARIANTS,
    GROUP_CONCAT(DISTINCT T21.courseName) AS COURSE_NAME,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info
        WHERE
            fire_base_persons_info.userId = T3.userId) AS DEVICE_ID
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
    academy_location T7 on T7.id = T5.academyLocationId
        LEFT OUTER JOIN
    academy_location_addresses ala on ala.academyLocationId = T7.id
        LEFT OUTER JOIN
    address T9 ON T9.id = ala.addressId 
        LEFT OUTER JOIN
    city T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    country T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    country_region T12 ON T12.id = T10.countryRegionId
        LEFT OUTER JOIN
    prog_batch_seat_config T13 on T13.id = T1.progBatchSeatConfigId
        LEFT OUTER JOIN
    seat_types T14 on T14.id = T13.seatTypeId
        LEFT OUTER JOIN
    academic_term T15 on T15.id = T6.academicTermId
        LEFT OUTER JOIN
    intake_year T16 on T16.id = T4.intakeYearId
        LEFT OUTER JOIN
    users T17 on T17.id = T3.userId
        LEFT OUTER JOIN
    persons T18 on T18.id = T3.personId
     LEFT OUTER JOIN  
     student_course_enrollment T19 on T19.admissionId=T2.id
     LEFT OUTER JOIN 
     course_variants T20 on T20.id=T19.courseVarientId
     LEFT OUTER JOIN
     courses T21 on T21.id=T20.courseId
     LEFT OUTER JOIN  
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null
AND T2.id in (namedParams) AND DATE(T19.enrollmentDate)=DATE(now()) AND TIMESTAMPDIFF(SECOND, T19.lastUpdate, NOW()) <=5",
'{
 "id": 1,
     "searchResultViewColumns": [
      {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 4
        },       
        {
            "id": 6,
            "value": "printName",
            "resultKey": "INTAKE_NAME",
            "displayCode": "",
            "displayOrder": 5
        },       
        {
            "id": 7,
            "value": "printName",
            "resultKey": "PERIOD_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "code",
            "resultKey": "ADMISSION_ID",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 10
        },
         {
            "id": 12,
            "value": "alternateEmailId",
            "resultKey": "SECONDARY_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 12
        },
         {
            "id": 14,
            "value": "mobileCountryCode",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 13
        },
         {
            "id": 15,
            "value": "courseVariantCode",
            "resultKey": "COURSE_VARIANTS",
            "displayCode": "",
            "displayOrder": 14
        },
         {
            "id": 16,
            "value": "courseName",
            "resultKey": "COURSE_NAME",
            "displayCode": "",
            "displayOrder": 15
        }
    ]}');

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='COURSE_REGISTRATION_CONFIRMATION_PORTALS');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='COURSE_REGISTRATION_CONFIRMATION_PORTALS');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='COURSE_REGISTRATION_CONFIRMATION_PORTALS_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Course Registration Confirmation Portals',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Course Registration Confirmation Portals',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1','English',1);

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Course Registration Confirmation','<html>
<head>
	<title></title>
</head>
<body bgcolor="silver">
<p>&nbsp;Dear&nbsp;$recipientData[&quot;STUDENT_NAME&quot;]</p>

<p>Congratulations, you are now registered for the $recipientData[&quot;PROGRAM_NAME&quot;], $recipientData[&quot;INTAKE_NAME&quot;] $recipientData[&quot;PERIOD_NAME&quot;]. Your Student ID is&nbsp;$recipientData[&quot;STUDENT_ID&quot;] and your admission ID is&nbsp;$recipientData[&quot;ADMISSION_ID&quot;] at&nbsp;$recipientData[&quot;ACADEMY_LOCATION&quot;]</p>

<p>The details of your course are -</p>

<table border="1" cellpadding="1" cellspacing="1" style="width:900px;">
	<tbody>
		<tr>
			<td style="text-align: center;font-weight: bold">Course Name</td>
			<td style="text-align: center;font-weight: bold">Course Variant</td>
		</tr>
#foreach ($Data in $recipientData[&quot;courseList&quot;] )
		<tr>
			<td style="text-align: left">$Data.courseName</td>
			<td style="text-align: left">$Data.courseVariant</td>
		</tr>
	</tbody>
#end
</table>

<p>&nbsp;</p>

<p>Please contact your campus if you have any questions regarding your course registration.</p>

<p>We wish you well as you embark on your academic journey with us.</p>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Course Registration Confirmation',
'<html>
<head>
	<title></title>
</head>
<body bgcolor="silver">
<p>&nbsp;Dear&nbsp;$recipientData[&quot;STUDENT_NAME&quot;]</p>

<p>Congratulations, you are now registered for the $recipientData[&quot;PROGRAM_NAME&quot;], $recipientData[&quot;INTAKE_NAME&quot;] $recipientData[&quot;PERIOD_NAME&quot;]. Your Student ID is&nbsp;$recipientData[&quot;STUDENT_ID&quot;] and your admission ID is&nbsp;$recipientData[&quot;ADMISSION_ID&quot;] at&nbsp;$recipientData[&quot;ACADEMY_LOCATION&quot;]</p>

<p>The details of your course are -</p>

<table border="1" cellpadding="1" cellspacing="1" style="width:900px;">
	<tbody>
		<tr>
			<td style="text-align: center;font-weight: bold">Course Name</td>
			<td style="text-align: center;font-weight: bold">Course Variant</td>
		</tr>
#foreach ($Data in $recipientData[&quot;courseList&quot;] )
		<tr>
			<td style="text-align: left">$Data.courseName</td>
			<td style="text-align: left">$Data.courseVariant</td>
		</tr>
	</tbody>
#end
</table>

<p>&nbsp;</p>

<p>Please contact your campus if you have any questions regarding your course registration.</p>

<p>We wish you well as you embark on your academic journey with us.</p>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'6','Course Registration Confirmation',
'<html>
<head>
	<title></title>
</head>
<body bgcolor="silver">
<p>&nbsp;Dear&nbsp;$recipientData[&quot;STUDENT_NAME&quot;]</p>

<p>Congratulations, you are now registered for the $recipientData[&quot;PROGRAM_NAME&quot;], $recipientData[&quot;INTAKE_NAME&quot;] $recipientData[&quot;PERIOD_NAME&quot;]. Your Student ID is&nbsp;$recipientData[&quot;STUDENT_ID&quot;] and your admission ID is&nbsp;$recipientData[&quot;ADMISSION_ID&quot;] at&nbsp;$recipientData[&quot;ACADEMY_LOCATION&quot;]</p>

<p>The details of your course are -</p>

<table border="1" cellpadding="1" cellspacing="1" style="width:900px;">
	<tbody>
		<tr>
			<td style="text-align: center;font-weight: bold">Course Name</td>
			<td style="text-align: center;font-weight: bold">Course Variant</td>
		</tr>
#foreach ($Data in $recipientData[&quot;courseList&quot;] )
		<tr>
			<td style="text-align: left">$Data.courseName</td>
			<td style="text-align: left">$Data.courseVariant</td>
		</tr>
	</tbody>
#end
</table>

<p>&nbsp;</p>

<p>Please contact your campus if you have any questions regarding your course registration.</p>

<p>We wish you well as you embark on your academic journey with us.</p>
</body>
</html>');

 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES(@msgtemplateId+4,@msgtemplateconfigId+1,'2',NULL,'Congratulations $recipientData[&quot;STUDENT_NAME&quot;], you are now registered for the $recipientData[&quot;PROGRAM_NAME&quot;], $recipientData[&quot;INTAKE_NAME&quot;] $recipientData[&quot;PERIOD_NAME&quot;]. Your Student ID is&nbsp;$recipientData[&quot;STUDENT_ID&quot;] and your admission ID is&nbsp;$recipientData[&quot;ADMISSION_ID&quot;] at&nbsp;$recipientData[&quot;ACADEMY_LOCATION&quot;]');
 
 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='COURSE_REGISTRATION_CONFIRMATION_PORTALS')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'COURSE_REGISTRATION_CONFIRMATION_PORTALS', 'Course Registration Confirmation Portals', 'Course Registration Confirmation Portals', 'Kursus Registrasie Bevestiging Portale', 'Cổng xác nhận đăng ký khóa học',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='COURSE_REGISTRATION_CONFIRMATION_PORTALS_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'COURSE_REGISTRATION_CONFIRMATION_PORTALS_DL', 'Course Registration Confirmation Portals DL', 'Course Registration Confirmation Portals DL', 'Kursus Registrasie Bevestiging Portale DL', 'Cổng xác nhận đăng ký khóa học DL',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='COURSE_REGISTRATION_CONFIRMATION_PORTALS_RCPNT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'COURSE_REGISTRATION_CONFIRMATION_PORTALS_RCPNT', 'Course Registration Confirmation Portals Recipient', 'Course Registration Confirmation Portals Recipient', 'Kursus Registrasie Bevestiging Portale Ontvanger', 'Cổng xác nhận đăng ký khóa học Người nhận',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='COURSE_REGISTRATION_CONFIRMATION_PORTALS')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('COURSE_REGISTRATION_CONFIRMATION_PORTALS', 'Course Registration Confirmation Portals');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='COURSE_REGISTRATION_CONFIRMATION_PORTALS_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('COURSE_REGISTRATION_CONFIRMATION_PORTALS_DL', 'Course Registration Confirmation Portals DL');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='COURSE_REGISTRATION_CONFIRMATION_PORTALS_RCPNT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('COURSE_REGISTRATION_CONFIRMATION_PORTALS_RCPNT', 'Course Registration Confirmation Portals Recipient');
END IF;
 
 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='INTAKE_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'INTAKE_NAME', 'Batch Name', 'Batch Name', 'Batch Naam', 'Tên lô',now(),1);
END IF;

END $$
CALL V20240612144421__Create_CourseRegistrationConfirmationEvent () $$ 
DROP PROCEDURE IF EXISTS V20240612144421__Create_CourseRegistrationConfirmationEvent $$ 
DELIMITER ;