DELIMITER $$
DROP PROCEDURE IF EXISTS V20240614103906__Create_canvasCourseMapping $$
CREATE PROCEDURE V20240614103906__Create_canvasCourseMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='canvas_course_mapping')) THEN 
CREATE TABLE canvas_course_mapping (
    id bigint NOT NULL AUTO_INCREMENT,
    canvasCourseId bigint,
    academiaCourseId bigint NOT NULL,
	academyLocationId bigint NOT NULL,
    remark VARCHAR(255),
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_canvas_course_mapping_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_canvas_course_mapping_academiaCourseId_idx (academiaCourseId),
  KEY fk_canvas_course_mapping_academyLocationId_idx (academyLocationId),
  CONSTRAINT fk_canvas_course_mapping_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_canvas_course_mapping_academiaCourseId FOREIGN KEY (academiaCourseId) REFERENCES courses (id),
  CONSTRAINT fk_canvas_course_mapping_academyLocationId FOREIGN KEY (academyLocationId) REFERENCES academy_location (id)
) ENGINE=InnoDB;
END IF; 

END $$
CALL V20240614103906__Create_canvasCourseMapping () $$ 
DROP PROCEDURE IF EXISTS V20240614103906__Create_canvasCourseMapping $$ 
DELIMITER ;