DELIMITER $$
DROP PROCEDURE IF EXISTS V20240712162322__Create_Readmission_Reason_CSM $$
CREATE PROCEDURE V20240712162322__Create_Readmission_Reason_CSM()
BEGIN

IF NOT EXISTS (( SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='readmission_reason_csm')) THEN 
CREATE TABLE `readmission_reason_csm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP on update current_timestamp,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB;
END IF; 

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'READMISSION_REASON_CSM')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'readmission_reason_csm','READMISSION_REASON_CSM','Fees & Payments','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;


IF  EXISTS ((select * from standard_master where tableName = 'readmission_reason_csm')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'readmission_reason_csm');
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='ITEM_CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('itemCode','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='ITEM_VALUE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('itemValue','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
END IF; 


-- ------------------TRANSLATION-------------------------------------------------

   IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'READMISSION_REASON_CSM')) THEN 
		INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
		VALUES ('masterNames', 'READMISSION_REASON_CSM', 'Readmission Reason', 'Readmission Reason','Hertoelating Rede','Lý do nhập học lại',now(),1);
	END IF;


END $$
CALL V20240712162322__Create_Readmission_Reason_CSM () $$ 
DROP PROCEDURE IF EXISTS V20240712162322__Create_Readmission_Reason_CSM $$ 
DELIMITER ;