DELIMITER $$
DROP PROCEDURE IF EXISTS V20240722161045__Insert_EnrolledStudentsDataGrid $$
CREATE PROCEDURE V20240722161045__Insert_EnrolledStudentsDataGrid()
BEGIN

IF NOT EXISTS (((select * from data_grid where gridName='Academia.view.coursetransaction.sectionmanagement.CourseSectionStudentGrid' and portalId=1))) THEN 
INSERT INTO `data_grid`
(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('Academia.view.coursetransaction.sectionmanagement.CourseSectionStudentGrid',1,
'[
	{"id":null,"columnName":"STUDENT_ID",			"dataIndex":"studentId",	"columnVisibility":"SHOW",	"sequence":1,	"mandatory":false},
	{"id":null,"columnName":"ADMISSION_ID",			"dataIndex":"admissionId",	"columnVisibility":"SHOW",	"sequence":2,	"mandatory":false},
	{"id":null,"columnName":"STUDENT_NAME",			"dataIndex":"studentName",	"columnVisibility":"SHOW",	"sequence":3,	"mandatory":false},
	{"id":null,"columnName":"STUDENT_FIRST_NAME",	"dataIndex":"firstName",	"columnVisibility":"HIDE",	"sequence":4,	"mandatory":false},
	{"id":null,"columnName":"STUDENT_MIDDLE_NAME",	"dataIndex":"middleName",	"columnVisibility":"HIDE",	"sequence":5,	"mandatory":false},
	{"id":null,"columnName":"STUDENT_LAST_NAME",	"dataIndex":"lastName",		"columnVisibility":"HIDE",	"sequence":6,	"mandatory":false},
	{"id":null,"columnName":"PROGRAM",				"dataIndex":"programCode",	"columnVisibility":"SHOW",	"sequence":7,	"mandatory":false},
	{"id":null,"columnName":"BATCH",				"dataIndex":"batchName",	"columnVisibility":"SHOW",	"sequence":8,	"mandatory":false},
	{"id":null,"columnName":"COURSE_VARIANT",		"dataIndex":"courseVariantCode","columnVisibility":"SHOW","sequence":9,	"mandatory":false},
	{"id":null,"columnName":"SECTION",				"dataIndex":"sectionCode",	"columnVisibility":"SHOW",	"sequence":10,	"mandatory":false},
	{"id":null,"columnName":"PERIOD",				"dataIndex":"period",		"columnVisibility":"SHOW",	"sequence":11,	"mandatory":false},
	{"id":null,"columnName":"DATE_OF_ENROLLMENT",	"dataIndex":"enrolledDate",	"columnVisibility":"SHOW",	"sequence":12,	"mandatory":false},
	{"id":null,"columnName":"ENROLLMENT_TYPE",			"dataIndex":"moduleType",	"columnVisibility":"SHOW",	"sequence":13,	"mandatory":false}]'
,now(),1);
END IF; 

END $$
CALL V20240722161045__Insert_EnrolledStudentsDataGrid() $$
DROP PROCEDURE IF EXISTS V20240722161045__Insert_EnrolledStudentsDataGrid $$
DELIMITER ;