DELIMITER $$
DROP PROCEDURE IF EXISTS V20240813153116__Insert_ExchangeSemesterDFR $$
CREATE PROCEDURE V20240813153116__Insert_ExchangeSemesterDFR()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'STD_EXCHANGE_SEMESTER_STATEMENT')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'STD_EXCHANGE_SEMESTER_STATEMENT', 'In order to process your Exchange semester request , please ensure personal details , contact details , Passport details and Parent and Sponsor details are up to date.', 'In order to process your Exchange semester request , please ensure personal details , contact details , Passport details and Parent and Sponsor details are up to date.','Om jou Uitruil-semesterversoek te verwerk, maak asseblief seker dat persoonlike besonderhede, kontakbesonderhede, paspoortbesonderhede en ouer- en borgbesonderhede op datum is.','Để xử lý yêu cầu học kỳ Exchange của bạn, vui lòng đảm bảo thông tin cá nhân, chi tiết liên hệ, chi tiết Hộ chiếu và chi tiết Phụ huynh và Nhà tài trợ được cập nhật.',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'exchangesemesterrequestdetailspanel' and  `formFieldId`='stdExchangeSemesterStatementId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('exchangesemesterrequestdetailspanel','stdExchangeSemesterStatement','stdExchangeSemesterStatementId','displayfield',0,0,NULL,1,now(),'In order to process your Exchange semester request , please ensure personal details , contact details , Passport details and Parent and Sponsor details are up to date.','','Exchange Semester','Create','In order to process your Exchange semester request , please ensure personal details , contact details , Passport details and Parent and Sponsor details are up to date.',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'exchangesemesterrequestdetailspanel' and  `formFieldId`='visaRefusalCheck')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('exchangesemesterrequestdetailspanel','visaRefusalCheck','visaRefusalCheck','checkbox',0,0,NULL,1,now(),'Please tick if you had a visa refusal in any country','','Exchange Semester','Create','Please tick if you had a visa refusal in any country',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'exchangesemesterrequestdetailspanel' and  `formFieldId`='studiedInUkCheck')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('exchangesemesterrequestdetailspanel','studiedInUkCheck','studiedInUkCheck','checkbox',0,0,NULL,1,now(),'Please tick if you have ever studied in the UK','','Exchange Semester','Create','Please tick if you have ever studied in the UK',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'exchangesemesterrequestdetailspanel' and  `formFieldId`='healthInsuranceCheckId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('exchangesemesterrequestdetailspanel','healthInsuranceCheck','healthInsuranceCheckId','checkbox',0,0,NULL,1,now(),'Please tick here if you require to register for the School Health Insurance','','Exchange Semester','Create','Please tick here if you require to register for the School Health Insurance',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'exchangesemesterrequestdetailspanel' and  `formFieldId`='scholarshipCheckId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('exchangesemesterrequestdetailspanel','scholarshipCheck','scholarshipCheckId','checkbox',0,0,NULL,1,now(),'Please tick here if you benefit from a Scholarship','','Exchange Semester','Create','Please tick here if you benefit from a Scholarship',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'exchangesemesterrequestdetailspanel' and  `formFieldId`='medicalIssuesCheckId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('exchangesemesterrequestdetailspanel','medicalIssuesCheck','medicalIssuesCheckId','checkbox',0,0,NULL,1,now(),'Please tick here if you suffer from any medical issues or learning differences','','Exchange Semester','Create','Please tick here if you suffer from any medical issues or learning differences',0);
END IF; 

END $$
CALL V20240813153116__Insert_ExchangeSemesterDFR() $$
DROP PROCEDURE IF EXISTS V20240813153116__Insert_ExchangeSemesterDFR $$
DELIMITER ;