DELIMITER $$
DROP PROCEDURE IF EXISTS V20240910165407__Alter_CalculateAverageLevelWise $$
CREATE PROCEDURE V20240910165407__Alter_CalculateAverageLevelWise()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='calculate_average_level_wise')) THEN 
	IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='calculate_average_level_wise' AND column_name='evaluationSubTypeId')) THEN 
		ALTER TABLE `calculate_average_level_wise` 
		DROP FOREIGN KEY `fk_calculate_average_level_wise_sequenceHeaderId`;
		ALTER TABLE `calculate_average_level_wise` 
		ADD COLUMN `evaluationSubTypeId` BIGINT NULL AFTER `sequenceHeaderId`,
		ADD COLUMN `evaluationTypeId` BIGINT NULL AFTER `evaluationSubTypeId`,
		ADD COLUMN `evaluationPlanId` BIGINT NULL AFTER `evaluationTypeId`,
		CHANGE COLUMN `sequenceHeaderId` `sequenceHeaderId` BIGINT NULL ,
		ADD INDEX `fk_calculate_average_level_wise_evaluationSubTypeId_idx` (`evaluationSubTypeId`),
		ADD INDEX `fk_calculate_average_level_wise_evaluationTypeId_idx` (`evaluationTypeId`) ,
		ADD INDEX `fk_calculate_average_level_wise_evaluationPlanId_idx` (`evaluationPlanId`) ;
		ALTER TABLE `calculate_average_level_wise` 
		ADD CONSTRAINT `fk_calculate_average_level_wise_sequenceHeaderId`
		  FOREIGN KEY (`sequenceHeaderId`)
		  REFERENCES `sequence_header` (`id`),
		ADD CONSTRAINT `fk_calculate_average_level_wise_evaluationSubTypeId`
		  FOREIGN KEY (`evaluationSubTypeId`)
		  REFERENCES `evaluation_sub_type` (`id`)
		  ON DELETE NO ACTION
		  ON UPDATE NO ACTION,
		ADD CONSTRAINT `fk_calculate_average_level_wise_evaluationTypeId_idx`
		  FOREIGN KEY (`evaluationTypeId`)
		  REFERENCES `evaluation_type` (`id`)
		  ON DELETE NO ACTION
		  ON UPDATE NO ACTION,
		ADD CONSTRAINT `fk_calculate_average_level_wise_evaluationPlanId_idx`
		  FOREIGN KEY (`evaluationPlanId`)
		  REFERENCES `evaluation_plan` (`id`)
		  ON DELETE NO ACTION
		  ON UPDATE NO ACTION;
	END IF;
END IF; 

END $$
CALL V20240910165407__Alter_CalculateAverageLevelWise() $$
DROP PROCEDURE IF EXISTS V20240910165407__Alter_CalculateAverageLevelWise $$
DELIMITER ;