DELIMITER $$
DROP PROCEDURE IF EXISTS get_plan_level_data_for_avg $$
CREATE PROCEDURE get_plan_level_data_for_avg(admissionIds text,batchId bigint)
BEGIN
SELECT DISTINCT
    ranks.id AS id,
    ranks.admissionId AS admissionId,
    ranks.courseVariantId AS courseVariantId,
    ePlan.id AS levelId,
    period.programBatchId AS batchId,
    ranks.effectiveMarks AS effectiveMarks,
    ranks.obtainedMarks AS obtainedMarks,
    ePlan.evaluationPlanNumber AS levelName
FROM
    evaluation_plan_rank ranks
        JOIN
    evaluation_plan ePlan ON ePlan.id = ranks.evaluationPlanId
        JOIN
    course_variants cv ON cv.id = ranks.courseVariantId
        JOIN
    prog_batch_period_config period ON period.id = ranks.periodId
WHERE
    (ranks.whetherSpecialGrade IS NULL
        OR ranks.whetherSpecialGrade = FALSE)
        AND (cv.whetherTransferCredits IS NULL
        OR cv.whetherTransferCredits = FALSE)
        AND period.programBatchId = batchId
        AND FIND_IN_SET(ranks.admissionId, admissionIds);
END $$
DELIMITER ;