DELIMITER $$
DROP PROCEDURE IF EXISTS V20240913185119__Alter_promotionfailureReason $$
CREATE PROCEDURE V20240913185119__Alter_promotionfailureReason()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='promotion' AND column_name='failureReason')) THEN 
ALTER TABLE `promotion` 
ADD COLUMN `failureReason` VARCHAR(255) NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='student_promote_retain_queue_details')) THEN 
CREATE TABLE `student_promote_retain_queue_details` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `programId` BIGINT NOT NULL,
  `batchId` BIGINT NOT NULL,
  `periodId` BIGINT NOT NULL,
  `admissionId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL,
  `lastUpdatedBy` BIGINT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `programIdSPRD`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `batchIdSPRD`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `periodIdSPRD`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `admissionIdSPRD`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `lastUpdatedBySPRD`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF;

END $$
CALL V20240913185119__Alter_promotionfailureReason() $$
DROP PROCEDURE IF EXISTS V20240913185119__Alter_promotionfailureReason $$
DELIMITER ;