DELIMITER $$
DROP procedure IF EXISTS getDTEFModuleDetails  $$

CREATE PROCEDURE getDTEFModuleDetails(IN studentinfo TINYTEXT)
BEGIN
SET @query = CONCAT(
' select per.nationalID as nationalid,  concat(COALESCE(u.firstName,''), ' ', COALESCE(u.middleName,'')) as names, u.lastName as surname, p.programNameToBePrint as prog_name,',
' p.programCode as program_code, al.academyName as inst, al.locationName as campus, if(shr.id = null, "off", "on") as accomo, py.itemValue as study_year, period.programPeriodSeq as study_semester,',
' period.programPeriodStart as sem_start_date, period.programPeriodEnd as sem_end_date,  group_concat(distinct c.courseCode) as modules,',
' sce.admissionId, period.id as periodid, sce.id as stuCourseEnrollId, pbs.id as progBatchStuId, ',
' dmap.id as dmapid, dmap.studentCourseEnrollmentIds, dmap.programBatchStudentId, group_concat(distinct  dmap.responseStatus) as responseStatus, dmap.response, dmap.responseDate, dmap.lastUpdate, dmap.lastUpdatedBy',
' from student_course_enrollment sce ',
' join course_variants cv on sce.courseVarientId = cv.id',
' join courses c on cv.courseId = c.id',
' join admission a on sce.admissionId = a.id',
' join students s on a.studentId =s.userId',
' join persons per on s.personId = per.id',
' join users u on a.studentId = u.id',
' join program_batch_students pbs on a.id = pbs.admissionId',
' join prog_batch_period_config period on pbs.progBatchPeriodConfigId = period.id',
' join batches b on period.programBatchId = b.id',
' join programs p on b.programId = p.id',
' join academy_location al on p.academyLocationId = al.id',
' left join period_year py on period.periodYearId = py.id ',
' left join student_hostel_requirement shr on per.id = shr.personId',
' left join dtef_course_enrollment_mapping dmap on a.id = dmap.admissionId and pbs.id = dmap.programBatchStudentId and period.id = dmap.periodId',
' where  (u.code,sce.admissionId,period.id) in (',studentinfo,') and sce.exitDate is null and pbs.sectionId is not null',
' group by u.id,a.id,period.id');

PREPARE stmt FROM @query;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

END$$

DELIMITER ;

