DELIMITER $$
DROP PROCEDURE IF EXISTS V20240918183010__Update_sql_dtprovider_drive_recpnt $$
CREATE PROCEDURE V20240918183010__Update_sql_dtprovider_drive_recpnt()
BEGIN

SET SQL_SAFE_UPDATES=0;
update sql_dtprovider 
set sqlQuery = 'SELECT DISTINCT
    T1.id AS ID,
    T2.firstName AS FIRST_NAME,
    T2.lastName AS LAST_NAME,
    T2.printName AS USER_NAME,
    T2.emailId AS EMAIL_ID,
    T3.albumName AS ALBUM_NAME
FROM
    gallery_users AS T1
        LEFT JOIN
    users AS T2 ON T2.id = T1.userId
        LEFT JOIN
    gallery AS T3 ON T1.galleryId = T3.id
WHERE
    T1.id IN (namedParams) AND firstName IS NOT NULL' 
where dataProviderId = (select id from dtprovider where dataProviderName = "ACADEMIA_DRIVE_UPDATE_RECIPIENT");
SET SQL_SAFE_UPDATES=1;

END $$
CALL V20240918183010__Update_sql_dtprovider_drive_recpnt () $$
DROP PROCEDURE IF EXISTS V20240918183010__Update_sql_dtprovider_drive_recpnt $$
DELIMITER ;