DELIMITER $$
DROP PROCEDURE IF EXISTS V20240920155624__Create_KUSubTypeLevelMarksheetReport $$
CREATE PROCEDURE V20240920155624__Create_KUSubTypeLevelMarksheetReport()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet');

IF NOT EXISTS ((select * from report_template where templateCode = 'KU_SUBTYPE_LEVEL_MARKSHEET')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'KU_SUBTYPE_LEVEL_MARKSHEET', 'KU Sub Type Level Marksheet', 'KU_SUBTYPE_LEVEL_MARKSHEET.png', 'CommonReport_KU_SUBTYPE_LEVEL_MARKSHEET.jasper', 'EVALUATION_SUB_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'KU_SUBTYPE_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png');
END IF; 

set @tempId = (select max(id) from report_template where templateCode='KU_SUBTYPE_LEVEL_MARKSHEET' and templateName='KU Sub Type Level Marksheet');


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_OBTAIN_COURSE_EXM') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_OBTAIN_COURSE_EXM', 'Obtained in each Course at the Examination of', '1', now());
END IF; 

END $$
CALL V20240920155624__Create_KUSubTypeLevelMarksheetReport () $$ 
DROP PROCEDURE IF EXISTS V20240920155624__Create_KUSubTypeLevelMarksheetReport $$ 
DELIMITER ;