DELIMITER $$
DROP PROCEDURE IF EXISTS V20241001150804__Create_readmission_outcome $$
CREATE PROCEDURE V20241001150804__Create_readmission_outcome()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='readmission_outcome') THEN

CREATE TABLE readmission_outcome(
    id BIGINT(20) NOT NULL AUTO_INCREMENT, 
    itemCode VARCHAR(255) NOT NULL ,
    itemValue VARCHAR(255) NOT NULL,
    lastUpdatedBy BIGINT(20)NOT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP on update current_timestamp,
    PRIMARY KEY (id),
    UNIQUE(itemCode)
    );

	SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);  
    
INSERT INTO standard_master(`id`, `tableName`, `masterName`,`moduleName`,`filterCode`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES (@standardMasterMaxId + 1, 'readmission_outcome', 'readmission_outcome','Fees & Payments','COMMON_MASTER', 0, 0, '1', NOW());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='readmission_outcome')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','readmission_outcome','Readmission Outcome','Readmission Outcome','Herlesingsuitkoms','Kết quả tái nhập học',now(),1);     
 
END IF;


END $$
CALL V20241001150804__Create_readmission_outcome () $$ 
DROP PROCEDURE IF EXISTS V20241001150804__Create_readmission_outcome $$ 
DELIMITER ;