DELIMITER $$
DROP PROCEDURE IF EXISTS V20241028124206__Create_UWCProgramLevelCertificateReport $$
CREATE PROCEDURE V20241028124206__Create_UWCProgramLevelCertificateReport()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet'); 

IF NOT EXISTS (select * from report_template where templateCode='UWC_PROGRAM_LEVEL_CERTIFICATE_REPORT') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'UWC_PROGRAM_LEVEL_CERTIFICATE_REPORT', 'UWC Program Level Certificate', 'UWC_PROGRAM_LEVEL_CERTIFICATE_REPORT.png', 'CommonReport_UWC_PROGRAM_LEVEL_CERTIFICATE_REPORT.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'UWC_PROGRAM_LEVEL_CERTIFICATE_REPORT.jasper', 'AcademiaLogo.png');
END IF; 

set @tempUWC = (select max(id) from report_template where templateCode ='UWC_PROGRAM_LEVEL_CERTIFICATE_REPORT');


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_ISSUED_BY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_ISSUED_BY', 'ISSUED BY THE', '1', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_THE_UNIVERSITY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_THE_UNIVERSITY', 'The University of the Western Cape is a Public Higher Education institution established and regulated by the Higher Education Act, No. 101 of 1997 (Republic of South Africa), with the language of instruction being English. The University is duly accredited by the Council on Higher Education and its degrees and diplomas are registered on the National Qualifications Framework in terms of the South African Qualifications Authority Act, No. 58 of 1995.', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_SERVES_CONFIRM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_SERVES_CONFIRM', 'This serves to confirm that', '1', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_IDENTITY_PASS_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_IDENTITY_PASS_NO', 'Identity/passport number', '1', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_COMPLETED_COURSE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_COMPLETED_COURSE', 'completed the following continuing education course', '1', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_ON')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_ON', 'on', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_COURSE_DURATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_COURSE_DURATION', 'Course duration', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_MODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_MODE', 'Mode', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_MODE_INFO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_MODE_INFO', '(interaction with institutional teachers or supervisors, through lectures, tutorials, seminars, practicals, supervision, or other forms of required work)', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_CONDUCT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_CONDUCT', 'Conduct', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_SATISFACTORY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_SATISFACTORY', 'Satisfactory', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_CONDUCT_INFO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_CONDUCT_INFO', '(behaviour during the period of study, related to student discipline)', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_AWARDED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_AWARDED', 'and was awarded a', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_IN_RULE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_IN_RULE', 'in accordance with the Act, Statute and Rules of the University', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_DEAN')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_DEAN', 'Dean Faculty of Economic and Management Sciences', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_REGISTRAR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_REGISTRAR', 'Registrar', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_UNIVERSITY_CAPE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_UNIVERSITY_CAPE', 'UNIVERSITY OF THE WESTERN CAPE', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_UWC')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_UWC', 'UWC', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempUWC and keyValue='TRANS_SECURITY_KEY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempUWC, 'TRANS_SECURITY_KEY', 'SECURITY KEY', '1', NOW());
END IF;


END $$
CALL V20241028124206__Create_UWCProgramLevelCertificateReport () $$ 
DROP PROCEDURE IF EXISTS V20241028124206__Create_UWCProgramLevelCertificateReport $$ 
DELIMITER ;