DELIMITER $$
DROP PROCEDURE IF EXISTS V20241106104425__Insert_SchAwardLetterApplicantDocSupport $$
CREATE PROCEDURE V20241106104425__Insert_SchAwardLetterApplicantDocSupport()
BEGIN

SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM sql_dtprovider WHERE `dataProviderId`=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_NOMINATION_AWARDED_APPLICANT_DL'))) THEN

UPDATE sql_dtprovider SET sqlQuery="SELECT DISTINCT T1.id AS USER_ID, T2.academyLocationId AS ACADEMY_LOCATION_IDS FROM scholarship_nominate_or_award T1 INNER JOIN programs T2 ON T2.id=T1.programId WHERE T1.id IN (namedParams)" 
WHERE `dataProviderId`=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_NOMINATION_AWARDED_APPLICANT_DL');

END IF;

IF EXISTS ((SELECT * FROM sql_dtprovider WHERE `dataProviderId`=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_NOMINATION_AWARDED_APPLICANT_RECIPIENT'))) THEN

UPDATE sql_dtprovider SET sqlQuery=
"SELECT DISTINCT
    T1.id AS ID,
    T3.printName AS APPLICANT_PRINT_NAME,
	T3.firstName AS FIRST_NAME,
    T3.middleName AS MIDDLE_NAME,
    T3.lastName AS LAST_NAME,
    T3.emailId AS EMAIL_ID,
    T2.code AS APPLICANT_ID,
    CURDATE() AS CURRENT_DATE_TODAY,
    T3.externalSysRefOne AS APPLICANT_EXTERNAL_REFERENCE_NUMBER_1,
    T4.programName AS PROGRAM,
    T5.batchName AS BATCH,
    T8.scholarshipCode AS SCHOLARSHIP_ID,
    T8.scholarshipName AS SCHOLARSHIP_NAME,
    T8.scholarshipCategory AS SCHOLARSHIP_CATEGORY,
    T1.amount AS SCHOLARSHIP_AMOUNT,
    T11.printName AS SCHOLARSHIP_OWNER_NAME,
    T11.emailId AS SCHOLARSHIP_OWNER_EMAIL,
    T13.displayName AS AL,
    T14.addressText AS CURRENT_ADRESS,
    T15.cityName AS CITY,
    T16.countryName AS COUNTRY,
    T14.pincode AS PIN_CODE,
	'APPLICANT' AS USER_TYPE_KEY
FROM
    scholarship_nominate_or_award T1
		LEFT OUTER JOIN
	application T2 ON T1.applicantId = T2.id	
        LEFT OUTER JOIN
    applicant_person T3 ON T2.applicantPersonId = T3.id
	    LEFT OUTER JOIN
    programs T4 ON T1.programId = T4.id
       LEFT OUTER JOIN
    batches T5 ON T1.batchId = T5.id
       LEFT OUTER JOIN
	prog_batch_seat_config T6 ON T6.programBatchId= T5.id
       LEFT OUTER JOIN
    scholarship T8 ON T8.id = T1.scholarshipId
      LEFT OUTER JOIN
	scholarship_owners T10 ON  T10.scholarshipId=T8.id
     LEFT OUTER JOIN
	users T11 ON T10.ownerId=T11.id
      LEFT OUTER JOIN 
    academy_location T13 ON T13.id=T4.academyLocationId
      LEFT OUTER JOIN 
    applicant_address T14 ON T14.applicantPersonId = T3.id
      LEFT OUTER JOIN
    city T15 on  T15.id=T14.cityId
	  LEFT OUTER JOIN 
    country T16 ON T16.id=T14.countryId
      LEFT OUTER JOIN 
    address_type T17 ON T17.id=T14.addressTypeId AND T17.code='CRNT' AND T17.addressCategory='PERSON'
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_NOMINATION_AWARDED_APPLICANT_RECIPIENT');

END IF;

IF EXISTS ((SELECT * FROM msg_category WHERE `code`='SCH_NOMINATION_AWARDED_APPLICANT')) THEN

IF NOT EXISTS ((SELECT * FROM dydt_document_type WHERE `typeName`='Scholarship Award Letter - Applicant')) THEN

SET @dydtdocumenttypeId=(SELECT MAX(id) FROM `dydt_document_type`);
INSERT INTO `dydt_document_type` (`id`,`typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`)
VALUES (@dydtdocumenttypeId+1,'Scholarship Award Letter - Applicant', 'ACADEMY_LOCATION_LEVEL', '0', 'Scholarship Award Letter - Applicant', '0', '1');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf` WHERE `distrListProviderId`=(SELECT `id` FROM `dtprovider` WHERE `dataProviderName`='SCH_NOMINATION_AWARDED_APPLICANT_DL'));
SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
SET @msgscopeparamId=(select id from msg_scope_param where paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_rcpnt_doc`(`id`,`sysMsgEvtRcpntDefaultConfigId`,`docTypeId`,`docGenOwnerMappingDef`,`docGenParamMapDef`)
VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId,@dydtdocumenttypeId+1,@msgscopeparamId,'[{"MSG_PARAM":"CONTEXT_RECORD_ID","DOC_GEN_PARAM":"PRM_SCHOLARSHIP_AWARD_LETTER_APPLICANT_ID"}]');
-- Start : Mapping of Dynamic Document to MsgTemplate
SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM `msg_template_config_doc`);
SET @msgtemplateconfigId=(SELECT MAX(id) FROM `msg_template_config` WHERE `code`='Scholarship Nomination Awarded Applicant');
INSERT INTO `msg_template_config_doc` (`id`,`msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1,@msgtemplateconfigId,@sysmsgevtrcpntdocId+1);
-- End : Mapping of Dynamic Document to Msgtemplate
SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'Scholarship Award Letter - Applicant Details', '1');
SET @dydtdocumentdataproviderId=(SELECT MAX(id) FROM `dydt_document_data_provider`);
INSERT INTO `dydt_document_data_provider` (`id`,`dataProviderId`, `documentTypeId`) VALUES (@dydtdocumentdataproviderId+1,@dydtdataproviderId+1, @dydtdocumenttypeId+1);
-- SCH_AWARD_LETTER_APPLICANT_INFO this is first data provider for document gen
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`,
`sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId+1, 'SCH_AWARD_LETTER_APPLICANT_INFO', '1',null,'1', '1', 
'SELECT 
    T1.id AS id,
    T3.firstName AS first_name,
    T3.middleName AS middle_name,
    T3.lastName AS last_name,
    T2.code AS applicant_id,
    T3.externalSysRefOne AS external_ref_no,
    T3.emailId AS primary_email_id,
    T7.displayName AS academy_location,
    CURDATE() AS issue_date,
    T8.salutationName AS salutation,
    T6.scholarshipCode AS scholarship_id,
    T6.scholarshipName AS scholarship_name,
    T9.accountingYear AS accounting_year,
    T11.itemValue AS internal_administration,
    T1.amount AS amount,
    T10.sponsorName AS financing_institution,
    CONCAT(T4.programCode,"/",T4.programName) AS program_code_name,
    T7.logoUrl AS img_academy_location_logo,
    T7.headerUrl AS img_header_url,
    T7.footerUrl AS img_footer_url
FROM
    scholarship_nominate_or_award T1
        LEFT OUTER JOIN
    application T2 ON T1.applicantId = T2.id	
        LEFT OUTER JOIN
    applicant_person T3 ON T2.applicantPersonId = T3.id
        LEFT OUTER JOIN  
    programs T4 ON T1.programId = T4.id
       LEFT OUTER JOIN
    batches T5 ON T1.batchId = T5.id
       LEFT OUTER JOIN
    scholarship T6 ON T6.id = T1.scholarshipId
      LEFT OUTER JOIN
    academy_location T7 ON T7.id=T4.academyLocationId
      LEFT OUTER JOIN  
    salutations T8 ON T3.salutationId = T8.id
      LEFT OUTER JOIN 
    accounting_year T9 ON T1.accountingYearId = T9.id
      LEFT OUTER JOIN
    sponsors T10 ON T6.financingInstitutionId = T10.id
      LEFT OUTER JOIN
    internal_administrator T11 ON T6.internalFundAdministratorId = T11.id', 'PRM_SCHOLARSHIP_AWARD_LETTER_APPLICANT_ID',
    'first_name,middle_name,last_name,applicant_id,external_ref_no,primary_email_id,academy_location,issue_date,salutation,scholarship_id,scholarship_name,
accounting_year,internal_administration,amount,financing_institution,program_code_name,img_academy_location_logo,img_header_url,img_footer_url,',
'where T1.id=PRM_SCHOLARSHIP_AWARD_LETTER_APPLICANT_ID', '0');

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('first_name', 'First Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('middle_name', 'Middle Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('last_name', 'Last Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('applicant_id', 'Applicant ID',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('external_ref_no', 'External Ref No.',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('primary_email_id', 'Primary Email ID',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('academy_location', 'Academy Location',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('issue_date', 'Issue Date',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('salutation', 'Salutation',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('scholarship_id', 'Scholarship ID',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('scholarship_name', 'Scholarship Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('accounting_year', 'Accounting Year',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('internal_administration', 'Internal Administration',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('amount', 'Amount',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('financing_institution', 'Financing Institution',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('program_code_name', 'Program Code/Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('img_academy_location_logo', 'Academy location logo',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('img_header_url', 'Header URL',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('img_footer_url', 'Footer URL',@dydtdatalinitemId+1);

SET @dydtTemplateconfId=(SELECT MAX(id) FROM `dydt_template_conf`);
INSERT INTO `dydt_template_conf` (`id`, `documentTypeId`, `templateName`, `templateType`, `whetherDefault`,`templateContent`)
VALUES (@dydtTemplateconfId+1, @dydtdocumenttypeId+1, 'Scholarship Award Letter - Applicant', 'HTMLTEMPLATE', '0','');

END IF;

END IF;
SET SQL_SAFE_UPDATES=1;

END $$
CALL V20241106104425__Insert_SchAwardLetterApplicantDocSupport() $$
DROP PROCEDURE IF EXISTS V20241106104425__Insert_SchAwardLetterApplicantDocSupport $$
DELIMITER ;