DELIMITER $$
DROP PROCEDURE IF EXISTS fatchInvoiceToBePushInXero $$
CREATE PROCEDURE fatchInvoiceToBePushInXero(jobLastRunTimestamp timestamp)
BEGIN
SELECT 
    FUNC_INC_VAR_SESSION_REC() AS id,
    xUser.xeroContactId AS xeroContactId,
	xUser.academiaUserId as academiaUserId,
    bill.totalAmount AS unitAmount,
    bill.billNo AS invoiceNumber,
	bill.id AS billHeaderId,
    curr.currencyCode AS currencyCode,
    bill.billingDate AS billingDate,
    bill.dueDate AS dueDate,
    bill.reasonForManualBill AS reason,
    bill.billStatus AS billStatus,
    bill.academyLocationId AS academyLocationId,
    bill.cancellationDate AS cancellationDate,
    bill.cancellationNarration AS cancellationNarration,
    bill.raiseBillCategory AS raiseBillCategory,
    xeroInvMap.id as xeroInvDbId,
    prog.programNameLanguageThree as accountCode
    
FROM
    xero_user_mapping AS xUser
        JOIN
    bill_header AS bill ON (bill.studentId = xUser.academiaUserId
        AND bill.raiseBillCategory = 'BILL_RECEIVABLE')
        JOIN
	prog_batch_seat_config As pbsc on pbsc.id=bill.programBatchSeatConfigId
		join 
	batches as batch on batch.id=pbsc.programBatchId
       join 
	programs as prog on prog.id= batch.programId
        LEFT JOIN
    currency AS curr ON bill.currencyId = curr.id
        LEFT JOIN
    xero_invoice_mapping AS xeroInvMap ON (xeroInvMap.academiaBillHeaderId = bill.id and bill.academyLocationId =xeroInvMap.academyLocationId)
WHERE
    bill.totalAmount IS NOT NULL AND (xeroInvMap.id IS NULL or xeroInvMap.error is not null) ;
END $$ 
DELIMITER ;